/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.statistics.impl;

import java.time.Duration;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.statistics.CountersAndGauges;
import org.apache.hadoop.fs.s3a.statistics.StatisticsFromAwsSdk;

public final class StatisticsFromAwsSdkImpl
implements StatisticsFromAwsSdk {
    private final CountersAndGauges countersAndGauges;

    public StatisticsFromAwsSdkImpl(CountersAndGauges countersAndGauges) {
        this.countersAndGauges = countersAndGauges;
    }

    @Override
    public void updateAwsRequestCount(long count) {
        this.countersAndGauges.incrementCounter(Statistic.STORE_IO_REQUEST, count);
    }

    @Override
    public void updateAwsRetryCount(long count) {
        this.countersAndGauges.incrementCounter(Statistic.STORE_IO_RETRY, count);
    }

    @Override
    public void updateAwsThrottleExceptionsCount(long count) {
        this.countersAndGauges.incrementCounter(Statistic.STORE_IO_THROTTLED, count);
        this.countersAndGauges.addValueToQuantiles(Statistic.STORE_IO_THROTTLE_RATE, count);
    }

    @Override
    public void noteAwsRequestTime(Duration duration) {
    }

    @Override
    public void noteAwsClientExecuteTime(Duration duration) {
    }

    @Override
    public void noteRequestMarshallTime(Duration duration) {
    }

    @Override
    public void noteRequestSigningTime(Duration duration) {
    }

    @Override
    public void noteResponseProcessingTime(Duration duration) {
    }
}

