/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3.common.writer.S3Recoverable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S3Committer
implements RecoverableFsDataOutputStream.Committer {
    private static final Logger LOG = LoggerFactory.getLogger(S3Committer.class);
    private final S3AccessHelper s3AccessHelper;
    private final String uploadId;
    private final String objectName;
    private final List<PartETag> parts;
    private final long totalLength;

    S3Committer(S3AccessHelper s3AccessHelper, String objectName, String uploadId, List<PartETag> parts, long totalLength) {
        this.s3AccessHelper = (S3AccessHelper)Preconditions.checkNotNull((Object)s3AccessHelper);
        this.objectName = (String)Preconditions.checkNotNull((Object)objectName);
        this.uploadId = (String)Preconditions.checkNotNull((Object)uploadId);
        this.parts = (List)Preconditions.checkNotNull(parts);
        this.totalLength = totalLength;
    }

    public void commit() throws IOException {
        if (this.totalLength > 0L) {
            LOG.info("Committing {} with MPU ID {}", (Object)this.objectName, (Object)this.uploadId);
            AtomicInteger errorCount = new AtomicInteger();
            this.s3AccessHelper.commitMultiPartUpload(this.objectName, this.uploadId, this.parts, this.totalLength, errorCount);
            if (errorCount.get() == 0) {
                LOG.debug("Successfully committed {} with MPU ID {}", (Object)this.objectName, (Object)this.uploadId);
            } else {
                LOG.debug("Successfully committed {} with MPU ID {} after {} retries.", new Object[]{this.objectName, this.uploadId, errorCount.get()});
            }
        } else {
            LOG.debug("No data to commit for file: {}", (Object)this.objectName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commitAfterRecovery() throws IOException {
        if (this.totalLength > 0L) {
            LOG.info("Trying to commit after recovery {} with MPU ID {}", (Object)this.objectName, (Object)this.uploadId);
            try {
                this.s3AccessHelper.commitMultiPartUpload(this.objectName, this.uploadId, this.parts, this.totalLength, new AtomicInteger());
                return;
            }
            catch (IOException e) {
                LOG.info("Failed to commit after recovery {} with MPU ID {}. Checking if file was committed before...", (Object)this.objectName, (Object)this.uploadId);
                LOG.trace("Exception when committing:", (Throwable)e);
                try {
                    ObjectMetadata metadata = this.s3AccessHelper.getObjectMetadata(this.objectName);
                    if (this.totalLength == metadata.getContentLength()) return;
                    String message = String.format("Inconsistent result for object %s: conflicting lengths. Recovered committer for upload %s indicates %s bytes, present object is %s bytes", this.objectName, this.uploadId, this.totalLength, metadata.getContentLength());
                    LOG.warn(message);
                    throw new IOException(message, e);
                }
                catch (FileNotFoundException fnf) {
                    LOG.warn("Object {} not existing after failed recovery commit with MPU ID {}", (Object)this.objectName, (Object)this.uploadId);
                    throw new IOException(String.format("Recovering commit failed for object %s. Object does not exist and MultiPart Upload %s is not valid.", this.objectName, this.uploadId), e);
                }
            }
        } else {
            LOG.debug("No data to commit for file: {}", (Object)this.objectName);
        }
    }

    public RecoverableWriter.CommitRecoverable getRecoverable() {
        return new S3Recoverable(this.objectName, this.uploadId, this.parts, this.totalLength);
    }
}

