/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.template.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.template.domain.Template;
import org.apache.fineract.template.domain.TemplateEntity;
import org.apache.fineract.template.domain.TemplateMapper;
import org.apache.fineract.template.domain.TemplateRepository;
import org.apache.fineract.template.domain.TemplateType;
import org.apache.fineract.template.exception.TemplateNotFoundException;
import org.apache.fineract.template.service.TemplateDomainService;
import org.springframework.transaction.annotation.Transactional;

public class JpaTemplateDomainService
implements TemplateDomainService {
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_TEXT = "text";
    private static final String PROPERTY_ENTITY = "entity";
    private static final String PROPERTY_TYPE = "type";
    private final TemplateRepository templateRepository;

    public List<Template> getAll() {
        return this.templateRepository.findAll();
    }

    public Template findOneById(Long id) {
        return (Template)this.templateRepository.findById((Object)id).orElseThrow(() -> new TemplateNotFoundException(id));
    }

    @Transactional
    public CommandProcessingResult createTemplate(JsonCommand command) {
        Template template = Template.fromJson((JsonCommand)command);
        this.templateRepository.saveAndFlush((Object)template);
        return new CommandProcessingResultBuilder().withEntityId((Long)template.getId()).build();
    }

    @Transactional
    public CommandProcessingResult updateTemplate(Long templateId, JsonCommand command) {
        Template template = this.findOneById(templateId);
        template.setName(command.stringValueOfParameterNamed(PROPERTY_NAME));
        template.setText(command.stringValueOfParameterNamed(PROPERTY_TEXT));
        template.setEntity(TemplateEntity.values()[command.integerValueSansLocaleOfParameterNamed(PROPERTY_ENTITY)]);
        int templateTypeId = command.integerValueSansLocaleOfParameterNamed(PROPERTY_TYPE);
        template.setType(switch (templateTypeId) {
            case 0 -> TemplateType.DOCUMENT;
            case 2 -> TemplateType.SMS;
            default -> null;
        });
        JsonArray array = command.arrayOfParameterNamed("mappers");
        ArrayList<TemplateMapper> mappersList = new ArrayList<TemplateMapper>();
        for (JsonElement element : array) {
            mappersList.add(new TemplateMapper(element.getAsJsonObject().get("mappersorder").getAsInt(), element.getAsJsonObject().get("mapperskey").getAsString(), element.getAsJsonObject().get("mappersvalue").getAsString()));
        }
        template.setMappers(mappersList);
        this.templateRepository.saveAndFlush((Object)template);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)template.getId()).build();
    }

    @Transactional
    public CommandProcessingResult removeTemplate(Long templateId) {
        Template template = this.findOneById(templateId);
        this.templateRepository.delete((Object)template);
        return new CommandProcessingResultBuilder().withEntityId(templateId).build();
    }

    @Transactional
    public Template updateTemplate(Template template) {
        return (Template)this.templateRepository.saveAndFlush((Object)template);
    }

    public List<Template> getAllByEntityAndType(TemplateEntity entity, TemplateType type) {
        return this.templateRepository.findByEntityAndType(entity, type);
    }

    @Generated
    public JpaTemplateDomainService(TemplateRepository templateRepository) {
        this.templateRepository = templateRepository;
    }
}

