/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.spm.data.ScorecardData;
import org.apache.fineract.spm.data.ScorecardValue;
import org.apache.fineract.spm.domain.Question;
import org.apache.fineract.spm.domain.Response;
import org.apache.fineract.spm.domain.Scorecard;
import org.apache.fineract.spm.domain.Survey;
import org.apache.fineract.spm.exception.SurveyResponseNotAvailableException;
import org.apache.fineract.useradministration.domain.AppUser;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ScorecardMapper {
    private ScorecardMapper() {
    }

    public static List<Scorecard> map(ScorecardData scorecardData, Survey survey, AppUser appUser, Client client) {
        ArrayList<Scorecard> scorecards = new ArrayList<Scorecard>();
        List scorecardValues = scorecardData.getScorecardValues();
        if (scorecardValues != null && !scorecardValues.isEmpty()) {
            for (ScorecardValue scorecardValue : scorecardValues) {
                Scorecard scorecard = new Scorecard();
                scorecards.add(scorecard);
                scorecard.setSurvey(survey);
                ScorecardMapper.setQuestionAndResponse((ScorecardValue)scorecardValue, (Scorecard)scorecard, (Survey)survey);
                scorecard.setAppUser(appUser);
                scorecard.setClient(client);
                scorecard.setCreatedOn(DateUtils.getLocalDateTimeOfTenant());
                scorecard.setValue(scorecardValue.getValue());
            }
        } else {
            throw new SurveyResponseNotAvailableException();
        }
        return scorecards;
    }

    private static void setQuestionAndResponse(ScorecardValue scorecardValue, Scorecard scorecard, Survey survey) {
        List questions = survey.getQuestions();
        block0: for (Question question : questions) {
            if (!((Long)question.getId()).equals(scorecardValue.getQuestionId())) continue;
            scorecard.setQuestion(question);
            for (Response response : question.getResponses()) {
                if (!((Long)response.getId()).equals(scorecardValue.getResponseId())) continue;
                scorecard.setResponse(response);
                break block0;
            }
        }
    }
}

