/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.reaging;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepository;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.serialization.JsonParserHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.portfolio.loanaccount.api.request.ReAgePreviewRequest;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.reaging.LoanReAgeInterestHandlingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.springframework.stereotype.Component;

@Component
public class LoanReAgingValidator {
    private final LoanTransactionRepository loanTransactionRepository;
    private final CodeValueRepository codeValueRepository;
    private final FromJsonHelper fromApiJsonHelper;
    private final List<String> reAgeSupportedParameters = List.of("externalId", "startDate", "frequencyType", "frequencyNumber", "numberOfInstallments", "reAgeInterestHandling", "reasonCodeValueId", "transactionAmount", "locale", "dateFormat", "note");

    public void validateReAge(Loan loan, JsonCommand command) {
        this.validateJSONAndCheckForUnsupportedParams(command.json());
        this.validateReAgeRequest(loan, command);
        this.validateReAgeBusinessRules(loan);
        this.validateReAgeOutstandingBalance(loan, command);
    }

    public void validateReAge(Loan loan, ReAgePreviewRequest reAgePreviewRequest) {
        this.validateReAgeRequest(loan, reAgePreviewRequest);
        this.validateReAgeBusinessRules(loan);
        this.validateReAgeOutstandingBalance(loan, reAgePreviewRequest);
    }

    private void validateJSONAndCheckForUnsupportedParams(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)this.reAgeSupportedParameters);
    }

    private void validateReAgeRequest(Loan loan, JsonCommand command) {
        CodeValue reasonCodeValue;
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.reAge");
        String externalId = command.stringValueOfParameterNamedAllowingNull("externalId");
        baseDataValidator.reset().parameter("externalId").ignoreIfNull().value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        LocalDate startDate = command.localDateValueOfParameterNamed("startDate");
        if (loan.isProgressiveSchedule()) {
            baseDataValidator.reset().parameter("startDate").value((Object)startDate).notNull().validateDateAfterOrEqual(loan.getDisbursementDate());
        } else {
            baseDataValidator.reset().parameter("startDate").value((Object)startDate).notNull().validateDateAfter(loan.getMaturityDate());
        }
        String frequencyType = command.stringValueOfParameterNamedAllowingNull("frequencyType");
        baseDataValidator.reset().parameter("frequencyType").value((Object)frequencyType).notNull();
        Integer frequencyNumber = command.integerValueOfParameterNamed("frequencyNumber");
        baseDataValidator.reset().parameter("frequencyNumber").value((Object)frequencyNumber).notNull().integerGreaterThanZero();
        Integer numberOfInstallments = command.integerValueOfParameterNamed("numberOfInstallments");
        baseDataValidator.reset().parameter("numberOfInstallments").value((Object)numberOfInstallments).notNull().integerGreaterThanZero();
        LoanReAgeInterestHandlingType reAgeInterestHandlingType = (LoanReAgeInterestHandlingType)command.enumValueOfParameterNamed("reAgeInterestHandling", LoanReAgeInterestHandlingType.class);
        baseDataValidator.reset().parameter("reAgeInterestHandling").value((Object)reAgeInterestHandlingType).ignoreIfNull();
        Long reasonCodeValueId = command.longValueOfParameterNamed("reasonCodeValueId");
        baseDataValidator.reset().parameter("reasonCodeValueId").value((Object)reasonCodeValueId).ignoreIfNull();
        if (reasonCodeValueId != null && (reasonCodeValue = this.codeValueRepository.findByCodeNameAndId("ReAgeReasons", reasonCodeValueId)) == null) {
            dataValidationErrors.add(ApiParameterError.parameterError((String)"validation.msg.reage.reason.invalid", (String)("Reage Reason with ID " + reasonCodeValueId + " does not exist"), (String)"ReAgeReasons", (Object[])new Object[0]));
        }
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        baseDataValidator.reset().parameter("transactionAmount").value((Object)transactionAmount).ignoreIfNull().positiveAmount();
        this.throwExceptionIfValidationErrorsExist(dataValidationErrors);
    }

    private void validateReAgeBusinessRules(Loan loan) {
        if (!loan.isProgressiveSchedule() && DateUtils.isBefore((LocalDate)DateUtils.getBusinessLocalDate(), (LocalDate)loan.getMaturityDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.cannot.be.submitted.before.maturity", "Loan cannot be re-aged before maturity", new Object[]{loan.getId()});
        }
        LoanScheduleType loanScheduleType = LoanScheduleType.valueOf((String)loan.getLoanProductRelatedDetail().getLoanScheduleType().name());
        boolean isProgressiveSchedule = LoanScheduleType.PROGRESSIVE.equals((Object)loanScheduleType);
        String transactionProcessingStrategyCode = loan.getTransactionProcessingStrategyCode();
        boolean isAdvancedPaymentSchedule = "advanced-payment-allocation-strategy".equals(transactionProcessingStrategyCode);
        if (!isProgressiveSchedule || !isAdvancedPaymentSchedule) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.supported.only.for.progressive.loan.schedule.type", "Loan reaging is only available for progressive repayment schedule and Advanced payment allocation strategy", new Object[]{loan.getId()});
        }
        if (!loan.getStatus().isActive()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.supported.only.for.active.loans", "Loan reaging can only be done on active loans", new Object[]{loan.getId()});
        }
        boolean isReAgingTransactionForTodayPresent = this.loanTransactionRepository.existsNonReversedByLoanAndTypeAndDate(loan, LoanTransactionType.REAGE, DateUtils.getBusinessLocalDate());
        if (isReAgingTransactionForTodayPresent) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.reage.transaction.already.present.for.today", "Loan reaging can only be done once a day. There has already been a reaging done for today", new Object[]{loan.getId()});
        }
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.not.allowed.on.charged.off", "Loan re-aging is not allowed on charged-off loan.", new Object[]{loan.getId()});
        }
        if (loan.isContractTermination()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.not.allowed.on.contract.terminated", "Loan re-aging is not allowed on contract terminated loan.", new Object[]{loan.getId()});
        }
    }

    public void validateUndoReAge(Loan loan) {
        this.validateUndoReAgeBusinessRules(loan);
    }

    private void validateUndoReAgeBusinessRules(Loan loan) {
        Optional<LoanTransaction> optionalReAgingTx = loan.getLoanTransactions().stream().filter(tx -> tx.getTypeOf().isReAge()).min(Comparator.comparing(LoanTransaction::getTransactionDate));
        if (optionalReAgingTx.isEmpty()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.reaging.transaction.missing", "Undoing a reaging can only be done if there was a reaging already", new Object[]{loan.getId()});
        }
    }

    private void throwExceptionIfValidationErrorsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    private void validateReAgeOutstandingBalance(Loan loan, JsonCommand command) {
        LocalDate startDate;
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        boolean isBackdated = businessDate.isAfter(startDate = command.dateValueOfParameterNamed("startDate"));
        if (isBackdated) {
            return;
        }
        BigDecimal totalPrincipalOutstanding = loan.getSummary().getTotalPrincipalOutstanding();
        if (MathUtil.isZero((BigDecimal)totalPrincipalOutstanding)) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.no.outstanding.balance.to.reage", "Loan cannot be re-aged as there are no outstanding balances to be re-aged", new Object[]{loan.getId()});
        }
    }

    private void validateReAgeRequest(Loan loan, ReAgePreviewRequest reAgePreviewRequest) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.reAge");
        Locale locale = reAgePreviewRequest.getLocale() != null ? Locale.forLanguageTag(reAgePreviewRequest.getLocale()) : Locale.getDefault();
        LocalDate startDate = JsonParserHelper.convertFrom((String)reAgePreviewRequest.getStartDate(), (String)"startDate", (String)reAgePreviewRequest.getDateFormat(), (Locale)locale);
        if (loan.isProgressiveSchedule()) {
            baseDataValidator.reset().parameter("startDate").value((Object)startDate).validateDateAfterOrEqual(loan.getDisbursementDate());
        } else {
            baseDataValidator.reset().parameter("startDate").value((Object)startDate).validateDateAfter(loan.getMaturityDate());
        }
        this.throwExceptionIfValidationErrorsExist(dataValidationErrors);
    }

    private void validateReAgeOutstandingBalance(Loan loan, ReAgePreviewRequest reAgePreviewRequest) {
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        Locale locale = reAgePreviewRequest.getLocale() != null ? Locale.forLanguageTag(reAgePreviewRequest.getLocale()) : Locale.getDefault();
        LocalDate startDate = JsonParserHelper.convertFrom((String)reAgePreviewRequest.getStartDate(), (String)"startDate", (String)reAgePreviewRequest.getDateFormat(), (Locale)locale);
        boolean isBackdated = businessDate.isAfter(startDate);
        if (isBackdated) {
            return;
        }
        if (loan.getSummary().getTotalPrincipalOutstanding().compareTo(BigDecimal.ZERO) == 0) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.no.outstanding.balance.to.reage", "Loan cannot be re-aged as there are no outstanding balances to be re-aged", new Object[]{loan.getId()});
        }
    }

    @Generated
    public LoanReAgingValidator(LoanTransactionRepository loanTransactionRepository, CodeValueRepository codeValueRepository, FromJsonHelper fromApiJsonHelper) {
        this.loanTransactionRepository = loanTransactionRepository;
        this.codeValueRepository = codeValueRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
    }
}

