/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api.pointintime;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.DateParam;
import org.apache.fineract.portfolio.loanaccount.api.pointintime.LoansPointInTimeApi;
import org.apache.fineract.portfolio.loanaccount.api.pointintime.LoansPointInTimeApiDelegate;
import org.apache.fineract.portfolio.loanaccount.api.pointintime.data.RetrieveLoansPointInTimeExternalIdsRequest;
import org.apache.fineract.portfolio.loanaccount.api.pointintime.data.RetrieveLoansPointInTimeRequest;
import org.apache.fineract.portfolio.loanaccount.data.LoanPointInTimeData;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans/at-date")
@Component
@Tag(name="LoansPointInTime", description="API to enable clients to retrieve Loan states in a specific point in time")
public class LoansPointInTimeApiResource
implements LoansPointInTimeApi {
    private final LoansPointInTimeApiDelegate delegate;

    @GET
    @Path(value="{loanId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public LoanPointInTimeData retrieveLoanPointInTime(@PathParam(value="loanId") @Parameter(description="loanId", required=true) Long loanId, @QueryParam(value="date") @Parameter(description="date", required=true) DateParam dateParam, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String dateFormat, @QueryParam(value="locale") @Parameter(description="locale") String locale) {
        return this.delegate.retrieveLoanPointInTime(loanId, dateParam, dateFormat, locale);
    }

    @GET
    @Path(value="external-id/{loanExternalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public LoanPointInTimeData retrieveLoanPointInTimeByExternalId(@PathParam(value="loanExternalId") @Parameter(description="loanExternalId", required=true) String loanExternalIdStr, @QueryParam(value="date") @Parameter(description="date", required=true) DateParam dateParam, @QueryParam(value="dateFormat") @Parameter(description="dateFormat") String dateFormat, @QueryParam(value="locale") @Parameter(description="locale") String locale) {
        return this.delegate.retrieveLoanPointInTimeByExternalId(loanExternalIdStr, dateParam, dateFormat, locale);
    }

    @POST
    @Path(value="search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<LoanPointInTimeData> retrieveLoansPointInTime(@Parameter RetrieveLoansPointInTimeRequest request) {
        return this.delegate.retrieveLoansPointInTime(request);
    }

    @POST
    @Path(value="search/external-id")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<LoanPointInTimeData> retrieveLoansPointInTimeByExternalIds(@Parameter RetrieveLoansPointInTimeExternalIdsRequest request) {
        return this.delegate.retrieveLoansPointInTimeByExternalIds(request);
    }

    @Generated
    public LoansPointInTimeApiResource(LoansPointInTimeApiDelegate delegate) {
        this.delegate = delegate;
    }
}

