/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service.search;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.service.PagedRequest;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.domain.ClientRepository;
import org.apache.fineract.portfolio.client.service.search.domain.ClientSearchData;
import org.apache.fineract.portfolio.client.service.search.domain.ClientTextSearch;
import org.apache.fineract.portfolio.client.service.search.mapper.ClientSearchDataMapper;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class ClientSearchService {
    private final PlatformSecurityContext context;
    private final ClientRepository clientRepository;
    private final ClientSearchDataMapper clientSearchDataMapper;

    public Page<ClientSearchData> searchByText(PagedRequest<ClientTextSearch> searchRequest) {
        this.validateTextSearchRequest(searchRequest);
        return this.executeTextSearch(searchRequest);
    }

    private void validateTextSearchRequest(PagedRequest<ClientTextSearch> searchRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest must not be null");
        this.context.isAuthenticated();
    }

    private Page<ClientSearchData> executeTextSearch(PagedRequest<ClientTextSearch> searchRequest) {
        String hierarchy = this.context.authenticatedUser().getOffice().getHierarchy();
        Optional request = searchRequest.getRequest();
        String requestSearchText = request.map(ClientTextSearch::getText).orElse(null);
        String searchText = StringUtils.defaultString((String)requestSearchText, (String)"");
        PageRequest pageable = searchRequest.toPageable();
        return this.clientRepository.searchByText(searchText, (Pageable)pageable, hierarchy).map(arg_0 -> ((ClientSearchDataMapper)this.clientSearchDataMapper).map(arg_0));
    }

    @Generated
    public ClientSearchService(PlatformSecurityContext context, ClientRepository clientRepository, ClientSearchDataMapper clientSearchDataMapper) {
        this.context = context;
        this.clientRepository = clientRepository;
        this.clientSearchDataMapper = clientSearchDataMapper;
    }
}

