/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.calendar.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.AbstractFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.calendar.CalendarConstants;
import org.apache.fineract.portfolio.calendar.command.CalendarCommand;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarRemindBy;
import org.apache.fineract.portfolio.calendar.domain.CalendarWeekDaysType;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalendarCommandFromApiJsonDeserializer
extends AbstractFromApiJsonDeserializer<CalendarCommand> {
    private static final Set<String> SUPPORTED_PARAMETERS = CalendarConstants.CalendarSupportedParameters.getAllValues();
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CalendarCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public CalendarCommand commandFromApiJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String title = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.TITLE.getValue(), element);
        String description = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.DESCRIPTION.getValue(), element);
        String location = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.LOCATION.getValue(), element);
        LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue(), element);
        LocalDate endDate = this.fromApiJsonHelper.extractLocalDateNamed(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue(), element);
        LocalDate createdDate = this.fromApiJsonHelper.extractLocalDateNamed(CalendarConstants.CalendarSupportedParameters.CREATED_DATE.getValue(), element);
        Integer duration = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.DURATION.getValue(), element);
        Integer typeId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.TYPE_ID.getValue(), element);
        boolean repeating = this.fromApiJsonHelper.extractBooleanNamed(CalendarConstants.CalendarSupportedParameters.REPEATING.getValue(), element);
        Integer remindById = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.REMIND_BY_ID.getValue(), element);
        Integer firstReminder = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.FIRST_REMINDER.getValue(), element);
        Integer secondReminder = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.SECOND_REMINDER.getValue(), element);
        return new CalendarCommand(title, description, location, startDate, endDate, createdDate, duration, typeId, repeating, remindById, firstReminder, secondReminder);
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("calendar");
        String title = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.TITLE.getValue(), element);
        baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.TITLE.getValue()).value((Object)title).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.DESCRIPTION.getValue(), element)) {
            String description = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.DESCRIPTION.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.DESCRIPTION.getValue()).value((Object)description).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.LOCATION.getValue(), element)) {
            String location = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.LOCATION.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.LOCATION.getValue()).value((Object)location).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        String startDateStr = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue(), element);
        baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue()).value((Object)startDateStr).notBlank();
        if (!StringUtils.isBlank((CharSequence)startDateStr)) {
            LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue()).value((Object)startDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue(), element)) {
            String endDateStr = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue()).value((Object)endDateStr).notBlank();
            LocalDate endDate = this.fromApiJsonHelper.extractLocalDateNamed(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue()).value((Object)endDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.DURATION.getValue(), element)) {
            Integer duration = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.DURATION.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.DURATION.getValue()).value((Object)duration).ignoreIfNull();
        }
        Integer typeId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.TYPE_ID.getValue(), element);
        baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.TYPE_ID.getValue()).value((Object)typeId).notNull().inMinMaxRange(Integer.valueOf(CalendarEntityType.getMinValue()), Integer.valueOf(CalendarEntityType.getMaxValue()));
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.REPEATING.getValue(), element)) {
            boolean repeating = this.fromApiJsonHelper.extractBooleanNamed(CalendarConstants.CalendarSupportedParameters.REPEATING.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.REPEATING.getValue()).value((Object)repeating).notNull();
            if (repeating) {
                Integer frequency = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.FREQUENCY.getValue(), element);
                baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.FREQUENCY.getValue()).value((Object)frequency).notBlank().inMinMaxRange(Integer.valueOf(CalendarFrequencyType.getMinValue()), Integer.valueOf(CalendarFrequencyType.getMaxValue()));
                if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.INTERVAL.getValue(), element)) {
                    Integer interval = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.INTERVAL.getValue(), element);
                    baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.INTERVAL.getValue()).value((Object)interval).notNull().integerGreaterThanZero();
                }
                if (CalendarFrequencyType.fromInt((int)frequency).isWeekly()) {
                    Integer repeatsOnDay = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.REPEATS_ON_DAY.getValue(), element);
                    baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.REPEATS_ON_DAY.getValue()).value((Object)repeatsOnDay).notBlank().inMinMaxRange(Integer.valueOf(CalendarWeekDaysType.getMinValue()), Integer.valueOf(CalendarWeekDaysType.getMaxValue()));
                } else if (CalendarFrequencyType.fromInt((int)frequency).isMonthly()) {
                    CalendarUtils.validateNthDayOfMonthFrequency((DataValidatorBuilder)baseDataValidator, (String)CalendarConstants.CalendarSupportedParameters.REPEATS_ON_NTH_DAY_OF_MONTH.getValue(), (String)CalendarConstants.CalendarSupportedParameters.REPEATS_ON_LAST_WEEKDAY_OF_MONTH.getValue(), (JsonElement)element, (FromJsonHelper)this.fromApiJsonHelper);
                }
            }
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.REMIND_BY_ID.getValue(), element)) {
            Integer remindById = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.REMIND_BY_ID.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.REMIND_BY_ID.getValue()).value((Object)remindById).ignoreIfNull().inMinMaxRange(Integer.valueOf(CalendarRemindBy.getMinValue()), Integer.valueOf(CalendarRemindBy.getMaxValue()));
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.FIRST_REMINDER.getValue(), element)) {
            Integer firstReminder = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.FIRST_REMINDER.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.FIRST_REMINDER.getValue()).value((Object)firstReminder).ignoreIfNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.SECOND_REMINDER.getValue(), element)) {
            Integer secondReminder = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.SECOND_REMINDER.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.SECOND_REMINDER.getValue()).value((Object)secondReminder).ignoreIfNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.MEETING_TIME.getValue(), element)) {
            LocalTime meetingTime = this.fromApiJsonHelper.extractLocalTimeNamed(CalendarConstants.CalendarSupportedParameters.MEETING_TIME.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.MEETING_TIME.getValue()).value((Object)meetingTime).ignoreIfNull();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("calendar");
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.RESCHEDULE_BASED_ON_MEETING_DATES.getValue(), element)) {
            Boolean rescheduleBasedOnMeetingDates = this.fromApiJsonHelper.extractBooleanNamed(CalendarConstants.CalendarSupportedParameters.RESCHEDULE_BASED_ON_MEETING_DATES.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.RESCHEDULE_BASED_ON_MEETING_DATES.getValue()).value((Object)rescheduleBasedOnMeetingDates).validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.PRESENT_MEETING_DATE.getValue(), element)) {
            String presentMeetingDate = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.PRESENT_MEETING_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.PRESENT_MEETING_DATE.getValue()).value((Object)presentMeetingDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.NEW_MEETING_DATE.getValue(), element)) {
            String newMeetingDate = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.NEW_MEETING_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.NEW_MEETING_DATE.getValue()).value((Object)newMeetingDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.TITLE.getValue(), element)) {
            String title = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.TITLE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.TITLE.getValue()).value((Object)title).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.DESCRIPTION.getValue(), element)) {
            String description = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.DESCRIPTION.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.DESCRIPTION.getValue()).value((Object)description).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.LOCATION.getValue(), element)) {
            String location = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.LOCATION.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.LOCATION.getValue()).value((Object)location).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue(), element)) {
            String startDateStr = this.fromApiJsonHelper.extractStringNamed(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue()).value((Object)startDateStr).notNull();
            LocalDate startDate = this.fromApiJsonHelper.extractLocalDateNamed(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.START_DATE.getValue()).value((Object)startDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue(), element)) {
            LocalDate endDate = this.fromApiJsonHelper.extractLocalDateNamed(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.END_DATE.getValue()).value((Object)endDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.DURATION.getValue(), element)) {
            Integer duration = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.DURATION.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.DURATION.getValue()).value((Object)duration).ignoreIfNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.TYPE_ID.getValue(), element)) {
            Integer typeId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.TYPE_ID.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.TYPE_ID.getValue()).value((Object)typeId).notNull().inMinMaxRange(Integer.valueOf(CalendarEntityType.getMinValue()), Integer.valueOf(CalendarEntityType.getMaxValue()));
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.REPEATING.getValue(), element)) {
            boolean repeating = this.fromApiJsonHelper.extractBooleanNamed(CalendarConstants.CalendarSupportedParameters.REPEATING.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.REPEATING.getValue()).value((Object)repeating).notNull();
            if (repeating) {
                Integer frequency = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.FREQUENCY.getValue(), element);
                baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.FREQUENCY.getValue()).value((Object)frequency).notBlank().inMinMaxRange(Integer.valueOf(CalendarFrequencyType.getMinValue()), Integer.valueOf(CalendarFrequencyType.getMaxValue()));
                if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.INTERVAL.getValue(), element)) {
                    Integer interval = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.INTERVAL.getValue(), element);
                    baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.INTERVAL.getValue()).value((Object)interval).notNull().integerGreaterThanZero();
                }
                if (CalendarFrequencyType.fromInt((int)frequency).isWeekly()) {
                    if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.REPEATS_ON_DAY.getValue(), element)) {
                        Integer repeatsOnDay = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.REPEATS_ON_DAY.getValue(), element);
                        baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.REPEATS_ON_DAY.getValue()).value((Object)repeatsOnDay).notBlank().inMinMaxRange(Integer.valueOf(CalendarWeekDaysType.getMinValue()), Integer.valueOf(CalendarWeekDaysType.getMaxValue()));
                    }
                } else if (CalendarFrequencyType.fromInt((int)frequency).isMonthly()) {
                    CalendarUtils.validateNthDayOfMonthFrequency((DataValidatorBuilder)baseDataValidator, (String)CalendarConstants.CalendarSupportedParameters.REPEATS_ON_NTH_DAY_OF_MONTH.getValue(), (String)CalendarConstants.CalendarSupportedParameters.REPEATS_ON_LAST_WEEKDAY_OF_MONTH.getValue(), (JsonElement)element, (FromJsonHelper)this.fromApiJsonHelper);
                }
            }
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.REMIND_BY_ID.getValue(), element)) {
            Integer remindById = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.REMIND_BY_ID.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.REMIND_BY_ID.getValue()).value((Object)remindById).ignoreIfNull().inMinMaxRange(Integer.valueOf(CalendarRemindBy.getMinValue()), Integer.valueOf(CalendarRemindBy.getMaxValue()));
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.FIRST_REMINDER.getValue(), element)) {
            Integer firstReminder = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.FIRST_REMINDER.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.FIRST_REMINDER.getValue()).value((Object)firstReminder).ignoreIfNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.SECOND_REMINDER.getValue(), element)) {
            Integer secondReminder = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CalendarConstants.CalendarSupportedParameters.SECOND_REMINDER.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.SECOND_REMINDER.getValue()).value((Object)secondReminder).ignoreIfNull();
        }
        if (this.fromApiJsonHelper.parameterExists(CalendarConstants.CalendarSupportedParameters.MEETING_TIME.getValue(), element)) {
            LocalTime meetingTime = this.fromApiJsonHelper.extractLocalTimeNamed(CalendarConstants.CalendarSupportedParameters.MEETING_TIME.getValue(), element);
            baseDataValidator.reset().parameter(CalendarConstants.CalendarSupportedParameters.MEETING_TIME.getValue()).value((Object)meetingTime).ignoreIfNull();
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

