/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.jobs.executestandinginstructions;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.AbstractPlatformServiceUnavailableException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.jobs.exception.JobExecutionException;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.data.StandingInstructionData;
import org.apache.fineract.portfolio.account.data.StandingInstructionDuesData;
import org.apache.fineract.portfolio.account.domain.AccountTransferRecurrenceType;
import org.apache.fineract.portfolio.account.domain.StandingInstructionStatus;
import org.apache.fineract.portfolio.account.domain.StandingInstructionType;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.account.service.StandingInstructionReadPlatformService;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.DefaultScheduledDateGenerator;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.exception.InsufficientAccountBalanceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.jdbc.core.JdbcTemplate;

public class ExecuteStandingInstructionsTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteStandingInstructionsTasklet.class);
    private final StandingInstructionReadPlatformService standingInstructionReadPlatformService;
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection instructionData = this.standingInstructionReadPlatformService.retrieveAll(StandingInstructionStatus.ACTIVE.getValue());
        ArrayList errors = new ArrayList();
        for (StandingInstructionData data : instructionData) {
            boolean isDueForTransfer = false;
            AccountTransferRecurrenceType recurrenceType = data.getRecurrenceType();
            StandingInstructionType instructionType = data.getInstructionType();
            LocalDate transactionDate = DateUtils.getBusinessLocalDate();
            if (recurrenceType.isPeriodicRecurrence()) {
                DefaultScheduledDateGenerator scheduledDateGenerator = new DefaultScheduledDateGenerator();
                PeriodFrequencyType frequencyType = data.getRecurrenceFrequency();
                LocalDate startDate = data.getValidFrom();
                if (frequencyType.isMonthly()) {
                    if (DateUtils.isBefore((LocalDate)(startDate = startDate.withDayOfMonth(data.getRecurrenceOnDay())), (LocalDate)data.getValidFrom())) {
                        startDate = startDate.plusMonths(1L);
                    }
                } else if (frequencyType.isYearly() && DateUtils.isBefore((LocalDate)(startDate = startDate.withDayOfMonth(data.getRecurrenceOnDay()).withMonth(data.getRecurrenceOnMonth())), (LocalDate)data.getValidFrom())) {
                    startDate = startDate.plusYears(1L);
                }
                isDueForTransfer = scheduledDateGenerator.isDateFallsInSchedule(frequencyType, data.getRecurrenceInterval().intValue(), startDate, transactionDate);
            }
            BigDecimal transactionAmount = data.getAmount();
            if (data.getToAccountType().isLoanAccount() && (recurrenceType.isDuesRecurrence() || isDueForTransfer && instructionType.isDuesAmoutTransfer())) {
                StandingInstructionDuesData standingInstructionDuesData = this.standingInstructionReadPlatformService.retriveLoanDuesData(data.getToAccount().getId());
                if (data.getInstructionType().isDuesAmoutTransfer()) {
                    transactionAmount = standingInstructionDuesData.totalDueAmount();
                }
                if (recurrenceType.isDuesRecurrence()) {
                    isDueForTransfer = this.isDueForTransfer(standingInstructionDuesData);
                }
            }
            if (!isDueForTransfer || transactionAmount == null || transactionAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            SavingsAccount fromSavingsAccount = null;
            boolean isRegularTransaction = true;
            boolean isExceptionForBalanceCheck = false;
            AccountTransferDTO accountTransferDTO = new AccountTransferDTO(transactionDate, transactionAmount, data.getFromAccountType(), data.getToAccountType(), data.getFromAccount().getId(), data.getToAccount().getId(), data.getName() + " Standing instruction trasfer ", null, null, null, null, data.toTransferType(), null, null, data.getTransferType().getValue(), null, null, ExternalId.empty(), null, null, fromSavingsAccount, Boolean.valueOf(true), Boolean.valueOf(false));
            boolean transferCompleted = this.transferAmount(errors, accountTransferDTO, data.getId());
            if (!transferCompleted) continue;
            String updateQuery = "UPDATE m_account_transfer_standing_instructions SET last_run_date = ? where id = ?";
            this.jdbcTemplate.update("UPDATE m_account_transfer_standing_instructions SET last_run_date = ? where id = ?", new Object[]{transactionDate, data.getId()});
        }
        if (!errors.isEmpty()) {
            throw new JobExecutionException(errors);
        }
        return RepeatStatus.FINISHED;
    }

    private boolean transferAmount(List<Throwable> errors, AccountTransferDTO accountTransferDTO, Long instructionId) {
        boolean transferCompleted = true;
        StringBuilder errorLog = new StringBuilder();
        StringBuilder updateQuery = new StringBuilder("INSERT INTO m_account_transfer_standing_instructions_history (standing_instruction_id, " + this.sqlGenerator.escape("status") + ", amount,execution_time, error_log) VALUES (");
        try {
            this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
        }
        catch (PlatformApiDataValidationException e) {
            errors.add(new Exception("Validation exception while transfering funds for standing Instruction id" + instructionId + " from " + accountTransferDTO.getFromAccountId() + " to " + accountTransferDTO.getToAccountId(), e));
            errorLog.append("Validation exception while trasfering funds ").append(e.getDefaultUserMessage());
        }
        catch (InsufficientAccountBalanceException e) {
            errors.add(new Exception("InsufficientAccountBalance Exception while trasfering funds for standing Instruction id" + instructionId + " from " + accountTransferDTO.getFromAccountId() + " to " + accountTransferDTO.getToAccountId(), e));
            errorLog.append("InsufficientAccountBalance Exception ");
        }
        catch (AbstractPlatformServiceUnavailableException e) {
            errors.add(new Exception("Platform exception while trasfering funds for standing Instruction id" + instructionId + " from " + accountTransferDTO.getFromAccountId() + " to " + accountTransferDTO.getToAccountId(), e));
            errorLog.append("Platform exception while trasfering funds ").append(e.getDefaultUserMessage());
        }
        catch (Exception e) {
            errors.add(new Exception("Unhandled System Exception while trasfering funds for standing Instruction id" + instructionId + " from " + accountTransferDTO.getFromAccountId() + " to " + accountTransferDTO.getToAccountId(), e));
            errorLog.append("Exception while trasfering funds ").append(e.getMessage());
        }
        updateQuery.append(instructionId).append(",");
        if (errorLog.length() > 0) {
            transferCompleted = false;
            updateQuery.append("'failed'").append(",");
        } else {
            updateQuery.append("'success'").append(",");
        }
        updateQuery.append(accountTransferDTO.getTransactionAmount().doubleValue());
        updateQuery.append(", now(),");
        updateQuery.append("'").append((CharSequence)errorLog).append("')");
        this.jdbcTemplate.update(updateQuery.toString());
        return transferCompleted;
    }

    public boolean isDueForTransfer(StandingInstructionDuesData standingInstructionDuesData) {
        return standingInstructionDuesData.dueDate() != null && !standingInstructionDuesData.dueDate().isAfter(LocalDate.now(DateUtils.getDateTimeZoneOfTenant()));
    }

    @Generated
    public ExecuteStandingInstructionsTasklet(StandingInstructionReadPlatformService standingInstructionReadPlatformService, JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, AccountTransfersWritePlatformService accountTransfersWritePlatformService) {
        this.standingInstructionReadPlatformService = standingInstructionReadPlatformService;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
    }
}

