/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.mix.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.mix.domain.MixTaxonomyMapping;
import org.apache.fineract.mix.domain.MixTaxonomyMappingRepository;
import org.apache.fineract.mix.service.MixTaxonomyMappingWritePlatformService;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class MixTaxonomyMappingWritePlatformServiceImpl
implements MixTaxonomyMappingWritePlatformService {
    private final MixTaxonomyMappingRepository mappingRepository;

    @Transactional
    public CommandProcessingResult updateMapping(Long mappingId, JsonCommand command) {
        try {
            MixTaxonomyMapping mapping = this.mappingRepository.findById((Object)mappingId).orElse(null);
            if (mapping == null) {
                mapping = MixTaxonomyMapping.fromJson((JsonCommand)command);
            } else {
                mapping.update(command);
            }
            this.mappingRepository.saveAndFlush((Object)mapping);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)mapping.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            return CommandProcessingResult.empty();
        }
    }

    @Generated
    public MixTaxonomyMappingWritePlatformServiceImpl(MixTaxonomyMappingRepository mappingRepository) {
        this.mappingRepository = mappingRepository;
    }
}

