/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.survey.service;

import java.util.ArrayList;
import org.apache.fineract.infrastructure.survey.data.LikeliHoodPovertyLineData;
import org.apache.fineract.infrastructure.survey.data.PovertyLineData;
import org.apache.fineract.infrastructure.survey.data.PpiPovertyLineData;
import org.apache.fineract.infrastructure.survey.service.PovertyLineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class PovertyLineServiceImpl
implements PovertyLineService {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    PovertyLineServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public PpiPovertyLineData retrieveAll(String ppiName) {
        SqlRowSet povertyLines = this.getPovertyLines(ppiName);
        SqlRowSet likelihoods = this.getLikelihoods();
        ArrayList<LikeliHoodPovertyLineData> listOfLikeliHoodPovertyLineData = new ArrayList<LikeliHoodPovertyLineData>();
        while (likelihoods.next()) {
            String codeName = likelihoods.getString("code");
            ArrayList<PovertyLineData> povertyLineDatas = new ArrayList<PovertyLineData>();
            while (povertyLines.next()) {
                String likelihoodCode = povertyLines.getString("code");
                if (!likelihoodCode.equals(codeName)) continue;
                povertyLineDatas.add(new PovertyLineData().setResourceId(Long.valueOf(povertyLines.getLong("id"))).setScoreFrom(Long.valueOf(povertyLines.getLong("score_from"))).setScoreTo(Long.valueOf(povertyLines.getLong("score_to"))).setPovertyLine(Double.valueOf(povertyLines.getDouble("poverty_line"))));
            }
            povertyLines.beforeFirst();
            LikeliHoodPovertyLineData likeliHoodPovertyLineData = new LikeliHoodPovertyLineData().setResourceId(likelihoods.getLong("id")).setPovertyLineData(povertyLineDatas).setLikeliHoodName(likelihoods.getString("name")).setLikeliHoodCode(likelihoods.getString("code")).setEnabled(likelihoods.getLong("enabled"));
            listOfLikeliHoodPovertyLineData.add(likeliHoodPovertyLineData);
        }
        PpiPovertyLineData ppiPovertyLineData = new PpiPovertyLineData().setLikeliHoodPovertyLineData(listOfLikeliHoodPovertyLineData).setPpi(ppiName);
        return ppiPovertyLineData;
    }

    public LikeliHoodPovertyLineData retrieveForLikelihood(String ppiName, Long likelihoodId) {
        SqlRowSet povertyLines = this.getPovertyLines(likelihoodId);
        ArrayList<PovertyLineData> povertyLineDatas = new ArrayList<PovertyLineData>();
        while (povertyLines.next()) {
            povertyLineDatas.add(new PovertyLineData().setResourceId(Long.valueOf(povertyLines.getLong("id"))).setScoreFrom(Long.valueOf(povertyLines.getLong("score_from"))).setScoreTo(Long.valueOf(povertyLines.getLong("score_to"))).setPovertyLine(Double.valueOf(povertyLines.getDouble("poverty_line"))));
        }
        povertyLines.first();
        return new LikeliHoodPovertyLineData().setResourceId(povertyLines.getLong("id")).setPovertyLineData(povertyLineDatas).setLikeliHoodName(povertyLines.getString("name")).setLikeliHoodCode(povertyLines.getString("code")).setEnabled(povertyLines.getLong("enabled"));
    }

    private SqlRowSet getLikelihoods() {
        String sql = "SELECT lkp.id, lkh.code , lkh.name, lkp.enabled  FROM ppi_likelihoods lkh  JOIN ppi_likelihoods_ppi lkp on lkp.likelihood_id = lkh.id ";
        return this.jdbcTemplate.queryForRowSet(sql);
    }

    private SqlRowSet getPovertyLines(String ppiName) {
        String sql = "SELECT pl.id, sc.score_from, sc.score_to , pl.poverty_line,lkh.code ,  lkh.name , lkp.ppi_name  FROM ppi_poverty_line pl  JOIN ppi_likelihoods lkh on lkh.id = pl.likelihood_ppi_id  JOIN ppi_likelihoods_ppi lkp on lkp.id = pl.likelihood_ppi_id  JOIN ppi_scores sc on sc.id = pl.score_id  WHERE lkp.ppi_name = ? ";
        return this.jdbcTemplate.queryForRowSet(sql, new Object[]{ppiName});
    }

    private SqlRowSet getPovertyLines(Long likelihoodId) {
        String sql = "SELECT pl.id, sc.score_from, sc.score_to , pl.poverty_line,lkh.code , lkp.enabled, lkp.id as likelihood_id , lkh.name , lkp.ppi_name  FROM ppi_poverty_line pl  JOIN ppi_likelihoods_ppi lkp on lkp.id = pl.likelihood_ppi_id  JOIN ppi_likelihoods lkh on lkh.id = lkp.likelihood_id  JOIN ppi_scores sc on sc.id = pl.score_id  WHERE pl.likelihood_ppi_id = ? ";
        return this.jdbcTemplate.queryForRowSet(sql, new Object[]{likelihoodId});
    }
}

