/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.entityaccess.service;

import jakarta.persistence.PersistenceException;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.entityaccess.data.FineractEntityDataValidator;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccess;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityAccessRepository;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelation;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityRelationRepositoryWrapper;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityToEntityMapping;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityToEntityMappingRepository;
import org.apache.fineract.infrastructure.entityaccess.domain.FineractEntityToEntityMappingRepositoryWrapper;
import org.apache.fineract.infrastructure.entityaccess.exception.FineractEntityToEntityMappingDateException;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessWriteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FineractEntityAccessWriteServiceImpl
implements FineractEntityAccessWriteService {
    private static final Logger LOG = LoggerFactory.getLogger(FineractEntityAccessWriteServiceImpl.class);
    private final FineractEntityAccessRepository entityAccessRepository;
    private final FineractEntityRelationRepositoryWrapper fineractEntityRelationRepositoryWrapper;
    private final FineractEntityToEntityMappingRepository fineractEntityToEntityMappingRepository;
    private final FineractEntityToEntityMappingRepositoryWrapper fineractEntityToEntityMappingRepositoryWrapper;
    private final FineractEntityDataValidator fromApiJsonDeserializer;

    @Autowired
    public FineractEntityAccessWriteServiceImpl(FineractEntityAccessRepository entityAccessRepository, FineractEntityRelationRepositoryWrapper fineractEntityRelationRepositoryWrapper, FineractEntityToEntityMappingRepository fineractEntityToEntityMappingRepository, FineractEntityToEntityMappingRepositoryWrapper fineractEntityToEntityMappingRepositoryWrapper, FineractEntityDataValidator fromApiJsonDeserializer) {
        this.entityAccessRepository = entityAccessRepository;
        this.fineractEntityToEntityMappingRepository = fineractEntityToEntityMappingRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.fineractEntityRelationRepositoryWrapper = fineractEntityRelationRepositoryWrapper;
        this.fineractEntityToEntityMappingRepositoryWrapper = fineractEntityToEntityMappingRepositoryWrapper;
    }

    public CommandProcessingResult createEntityAccess(JsonCommand command) {
        return null;
    }

    @Transactional
    public void addNewEntityAccess(String entityType, Long entityId, CodeValue accessType, String secondEntityType, Long secondEntityId) {
        FineractEntityAccess entityAccess = FineractEntityAccess.createNew((String)entityType, (Long)entityId, (CodeValue)accessType, (String)secondEntityType, (Long)secondEntityId);
        this.entityAccessRepository.save((Object)entityAccess);
    }

    @Transactional
    public CommandProcessingResult createEntityToEntityMapping(Long relId, JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            FineractEntityRelation mapId = this.fineractEntityRelationRepositoryWrapper.findOneWithNotFoundDetection(relId);
            Long fromId = command.longValueOfParameterNamed("fromId");
            Long toId = command.longValueOfParameterNamed("toId");
            LocalDate startDate = command.localDateValueOfParameterNamed("startDate");
            LocalDate endDate = command.localDateValueOfParameterNamed("endDate");
            this.fromApiJsonDeserializer.checkForEntity(relId.toString(), fromId, toId);
            if (endDate != null && DateUtils.isBefore((LocalDate)endDate, (LocalDate)startDate)) {
                throw new FineractEntityToEntityMappingDateException(startDate.toString(), endDate.toString());
            }
            FineractEntityToEntityMapping newMap = FineractEntityToEntityMapping.newMap((FineractEntityRelation)mapId, (Long)fromId, (Long)toId, (LocalDate)startDate, (LocalDate)endDate);
            this.fineractEntityToEntityMappingRepository.saveAndFlush((Object)newMap);
            return new CommandProcessingResultBuilder().withEntityId((Long)newMap.getId()).withCommandId(command.commandId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateEntityToEntityMapping(Long mapId, JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            FineractEntityToEntityMapping mapForUpdate = this.fineractEntityToEntityMappingRepositoryWrapper.findOneWithNotFoundDetection(mapId);
            String relId = ((Long)mapForUpdate.getRelationId().getId()).toString();
            Long fromId = command.longValueOfParameterNamed("fromId");
            Long toId = command.longValueOfParameterNamed("toId");
            this.fromApiJsonDeserializer.checkForEntity(relId, fromId, toId);
            Map changes = mapForUpdate.updateMap(command);
            if (!changes.isEmpty()) {
                this.fineractEntityToEntityMappingRepository.saveAndFlush((Object)mapForUpdate);
            }
            return new CommandProcessingResultBuilder().withEntityId((Long)mapForUpdate.getId()).withCommandId(command.commandId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult deleteEntityToEntityMapping(Long mapId) {
        FineractEntityToEntityMapping deleteMap = this.fineractEntityToEntityMappingRepositoryWrapper.findOneWithNotFoundDetection(mapId);
        this.fineractEntityToEntityMappingRepository.delete((Object)deleteMap);
        return new CommandProcessingResultBuilder().withEntityId((Long)deleteMap.getId()).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        LOG.error("Problem occurred in handleDataIntegrityIssues function", realCause);
        if (realCause.getMessage().contains("rel_id_from_id_to_id")) {
            String fromId = command.stringValueOfParameterNamed("fromId");
            String toId = command.stringValueOfParameterNamed("toId");
            throw new PlatformDataIntegrityException("error.msg.duplicate.entity.mapping", "EntityMapping from " + fromId + " to " + toId + " already exist", new Object[0]);
        }
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.entity.mapping", (String)"Unknown data integrity issue with resource.");
    }
}

