/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class EntityDatatableChecksDataValidator {
    public static final String ENTITY = "entity";
    public static final String STATUS = "status";
    public static final String SYSTEM_DEFINED = "systemDefined";
    public static final String PRODUCT_ID = "productId";
    public static final String ENTITY_DATATABLE_CHECKS = "entityDatatableChecks";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("entity", "datatableName", "status", "systemDefined", "productId"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public EntityDatatableChecksDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(ENTITY_DATATABLE_CHECKS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String entity = this.fromApiJsonHelper.extractStringNamed(ENTITY, element);
        baseDataValidator.reset().parameter(ENTITY).value((Object)entity).notBlank().isOneOfTheseStringValues(EntityTables.getEntityNames());
        Integer status = this.fromApiJsonHelper.extractIntegerSansLocaleNamed(STATUS, element);
        Object[] entityTablesStatuses = EntityTables.getCheckStatusCodes((String)entity).toArray();
        baseDataValidator.reset().parameter(STATUS).value((Object)status).isOneOfTheseValues(entityTablesStatuses);
        String datatableName = this.fromApiJsonHelper.extractStringNamed("datatableName", element);
        baseDataValidator.reset().parameter("datatableName").value((Object)datatableName).notBlank();
        if (this.fromApiJsonHelper.parameterExists(SYSTEM_DEFINED, element)) {
            String systemDefined = this.fromApiJsonHelper.extractStringNamed(SYSTEM_DEFINED, element);
            baseDataValidator.reset().parameter(SYSTEM_DEFINED).value((Object)systemDefined).validateForBooleanValue();
        }
        if (this.fromApiJsonHelper.parameterExists(PRODUCT_ID, element)) {
            long productId = this.fromApiJsonHelper.extractLongNamed(PRODUCT_ID, element);
            baseDataValidator.reset().parameter(PRODUCT_ID).value((Object)productId).integerZeroOrGreater();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

