/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.AbstractSamplingService;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySamplingService
extends AbstractSamplingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemorySamplingService.class);
    private final Map<String, List<Duration>> timings = new ConcurrentHashMap();

    InMemorySamplingService(int samplingRate) {
        super(samplingRate);
    }

    public SamplingData getSamplingData() {
        return new SamplingData(this.timings);
    }

    protected void takeSample(String key, Duration duration) {
        try {
            this.timings.merge(key, new CopyOnWriteArrayList<Duration>(List.of(duration)), (oldValues, newValue) -> {
                oldValues.addAll(newValue);
                return oldValues;
            });
        }
        catch (RuntimeException e) {
            log.error("Error while sampling for key [{}]", (Object)key, (Object)e);
        }
    }

    protected void doReset() {
        this.timings.clear();
    }
}

