/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.group;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.CenterSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class GroupsWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final PersonnelSheetPopulator personnelSheetPopulator;
    private final CenterSheetPopulator centerSheetPopulator;
    private final ClientSheetPopulator clientSheetPopulator;

    public GroupsWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, PersonnelSheetPopulator personnelSheetPopulator, CenterSheetPopulator centerSheetPopulator, ClientSheetPopulator clientSheetPopulator) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.personnelSheetPopulator = personnelSheetPopulator;
        this.centerSheetPopulator = centerSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
    }

    private void setFormatActivationAndSubmittedDate(Row row, int columnIndex, CellStyle cellStyle) {
        Cell cell = row.getCell(columnIndex);
        if (cell == null) {
            cell = row.createCell(columnIndex);
        }
        cell.setCellStyle(cellStyle);
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet groupSheet = workbook.createSheet("Groups");
        this.personnelSheetPopulator.populate(workbook, dateFormat);
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.centerSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.setLayout(groupSheet);
        this.setLookupTable(groupSheet, dateFormat);
        this.setFormatStyle(workbook, groupSheet);
        this.setRules(groupSheet, dateFormat);
    }

    private void setFormatStyle(Workbook workbook, Sheet worksheet) {
        CellStyle dateCellStyle = workbook.createCellStyle();
        CreationHelper createHelper = workbook.getCreationHelper();
        dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd"));
        for (int rowIndex = 1; rowIndex < SpreadsheetVersion.EXCEL97.getMaxRows(); ++rowIndex) {
            Row row = worksheet.getRow(rowIndex);
            if (row == null) {
                row = worksheet.createRow(rowIndex);
            }
            this.setFormatActivationAndSubmittedDate(row, 7, dateCellStyle);
            this.setFormatActivationAndSubmittedDate(row, 6, dateCellStyle);
            this.setFormatActivationAndSubmittedDate(row, 8, dateCellStyle);
        }
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 6000);
        worksheet.setColumnWidth(3, 6000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(8, 6000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(251, 6000);
        worksheet.setColumnWidth(252, 4000);
        worksheet.setColumnWidth(253, 4000);
        worksheet.setColumnWidth(254, 4000);
        worksheet.setColumnWidth(255, 4000);
        this.writeString(0, rowHeader, "Group Name*");
        this.writeString(1, rowHeader, "Office Name*");
        this.writeString(2, rowHeader, "Staff Name*");
        this.writeString(3, rowHeader, "Center Name");
        this.writeString(4, rowHeader, "External ID");
        this.writeString(5, rowHeader, "Active*");
        this.writeString(7, rowHeader, "Activation Date*");
        this.writeString(6, rowHeader, "Submitted On Date *");
        this.writeString(8, rowHeader, "Meeting Start Date* (On or After)");
        this.writeString(9, rowHeader, "Repeat*");
        this.writeString(10, rowHeader, "Frequency*");
        this.writeString(11, rowHeader, "Interval*");
        this.writeString(12, rowHeader, "Repeats On*");
        this.writeString(16, rowHeader, "Client Names* (Enter in consecutive cells horizontally)");
        this.writeString(251, rowHeader, "Office Name");
        this.writeString(252, rowHeader, "Opening Date");
        this.writeString(253, rowHeader, "Repeat Normal Range");
        this.writeString(254, rowHeader, "Repeat Monthly Range");
        this.writeString(255, rowHeader, "If Repeat Weekly Range");
    }

    private void setLookupTable(Sheet groupSheet, String dateFormat) {
        int rowIndex;
        this.setOfficeDateLookupTable(groupSheet, this.officeSheetPopulator.getOffices(), 251, 252, dateFormat);
        for (rowIndex = 1; rowIndex <= 11; ++rowIndex) {
            Row row = groupSheet.getRow(rowIndex);
            if (row == null) {
                row = groupSheet.createRow(rowIndex);
            }
            this.writeInt(254, row, rowIndex);
        }
        for (rowIndex = 1; rowIndex <= 3; ++rowIndex) {
            this.writeInt(253, groupSheet.getRow(rowIndex), rowIndex);
        }
        String[] days = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        for (rowIndex = 1; rowIndex <= 7; ++rowIndex) {
            this.writeString(255, groupSheet.getRow(rowIndex), days[rowIndex - 1]);
        }
    }

    private void setRules(Sheet worksheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList staffNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList centerNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList activeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList activationDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        CellRangeAddressList submittedOnDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList meetingStartDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 8, 8);
        CellRangeAddressList isRepeatRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 9, 9);
        CellRangeAddressList repeatsRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 10, 10);
        CellRangeAddressList repeatsEveryRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 11, 11);
        CellRangeAddressList repeatsOnRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 12, 12);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        List offices = this.officeSheetPopulator.getOffices();
        this.setNames(worksheet, offices);
        DataValidationConstraint centerNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Center_\",$B1))");
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint staffNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Staff_\",$B1))");
        DataValidationConstraint booleanConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint activationDateConstraint = validationHelper.createDateConstraint(6, "=$G1", null, dateFormat);
        DataValidationConstraint submittedOnDateConstraint = validationHelper.createDateConstraint(7, "=TODAY()", null, dateFormat);
        DataValidationConstraint meetingStartDateConstraint = validationHelper.createDateConstraint(0, "=$H1", "=TODAY()", dateFormat);
        DataValidationConstraint repeatsConstraint = validationHelper.createExplicitListConstraint(new String[]{"Daily", "Weekly", "Monthly", "Yearly"});
        DataValidationConstraint repeatsEveryConstraint = validationHelper.createFormulaListConstraint("INDIRECT($K1)");
        DataValidationConstraint repeatsOnConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE($K1,\"_DAYS\"))");
        DataValidation centerValidation = validationHelper.createValidation(centerNameConstraint, centerNameRange);
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation staffValidation = validationHelper.createValidation(staffNameConstraint, staffNameRange);
        DataValidation activationDateValidation = validationHelper.createValidation(activationDateConstraint, activationDateRange);
        DataValidation activeValidation = validationHelper.createValidation(booleanConstraint, activeRange);
        DataValidation submittedOnDateValidation = validationHelper.createValidation(submittedOnDateConstraint, submittedOnDateRange);
        DataValidation meetingStartDateValidation = validationHelper.createValidation(meetingStartDateConstraint, meetingStartDateRange);
        DataValidation isRepeatValidation = validationHelper.createValidation(booleanConstraint, isRepeatRange);
        DataValidation repeatsValidation = validationHelper.createValidation(repeatsConstraint, repeatsRange);
        DataValidation repeatsEveryValidation = validationHelper.createValidation(repeatsEveryConstraint, repeatsEveryRange);
        DataValidation repeatsOnValidation = validationHelper.createValidation(repeatsOnConstraint, repeatsOnRange);
        worksheet.addValidationData(centerValidation);
        worksheet.addValidationData(activeValidation);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(staffValidation);
        worksheet.addValidationData(activationDateValidation);
        worksheet.addValidationData(submittedOnDateValidation);
        worksheet.addValidationData(meetingStartDateValidation);
        worksheet.addValidationData(isRepeatValidation);
        worksheet.addValidationData(repeatsValidation);
        worksheet.addValidationData(repeatsEveryValidation);
        worksheet.addValidationData(repeatsOnValidation);
    }

    private void setNames(Sheet worksheet, List<OfficeData> offices) {
        Workbook centerWorkbook = worksheet.getWorkbook();
        Name officeCenter = centerWorkbook.createName();
        officeCenter.setNameName("Office");
        officeCenter.setRefersToFormula("Offices!$B$2:$B$" + (offices.size() + 1));
        Name repeatsDaily = centerWorkbook.createName();
        repeatsDaily.setNameName("Daily");
        repeatsDaily.setRefersToFormula("Groups!$IT$2:$IT$4");
        Name repeatsWeekly = centerWorkbook.createName();
        repeatsWeekly.setNameName("Weekly");
        repeatsWeekly.setRefersToFormula("Groups!$IT$2:$IT$4");
        Name repeatYearly = centerWorkbook.createName();
        repeatYearly.setNameName("Yearly");
        repeatYearly.setRefersToFormula("Groups!$IT$2:$IT$4");
        Name repeatsMonthly = centerWorkbook.createName();
        repeatsMonthly.setNameName("Monthly");
        repeatsMonthly.setRefersToFormula("Groups!$IU$2:$IU$12");
        Name repeatsOnWeekly = centerWorkbook.createName();
        repeatsOnWeekly.setNameName("Weekly_Days");
        repeatsOnWeekly.setRefersToFormula("Groups!$IV$2:$IV$8");
        Name repeatsOnDaily = centerWorkbook.createName();
        repeatsOnDaily.setNameName("Daily_Days");
        repeatsOnDaily.setRefersToFormula("Groups!$IV$2:$IV$8");
        Name repeatOnYearly = centerWorkbook.createName();
        repeatOnYearly.setNameName("Yearly_Days");
        repeatOnYearly.setRefersToFormula("Groups!$IV$2:$IV$8");
        Name repeatsOnMonthly = centerWorkbook.createName();
        repeatsOnMonthly.setNameName("Monthly_Days");
        repeatsOnMonthly.setRefersToFormula("Groups!$IV$2:$IV$8");
        Integer i = 0;
        while (i < offices.size()) {
            Integer[] officeNameToBeginEndIndexesOfCenters = (Integer[])this.centerSheetPopulator.getOfficeNameToBeginEndIndexesOfCenters().get(i);
            Integer[] officeNameToBeginEndIndexesOfStaff = (Integer[])this.personnelSheetPopulator.getOfficeNameToBeginEndIndexesOfStaff().get(i);
            Name loanOfficerName = centerWorkbook.createName();
            Name centerName = centerWorkbook.createName();
            if (officeNameToBeginEndIndexesOfStaff != null) {
                this.setSanitized(loanOfficerName, "Staff_" + offices.get(i).getName());
                loanOfficerName.setRefersToFormula("Staff!$B$" + officeNameToBeginEndIndexesOfStaff[0] + ":$B$" + officeNameToBeginEndIndexesOfStaff[1]);
            }
            if (officeNameToBeginEndIndexesOfCenters != null) {
                this.setSanitized(centerName, "Center_" + offices.get(i).getName());
                centerName.setRefersToFormula("Centers!$B$" + officeNameToBeginEndIndexesOfCenters[0] + ":$B$" + officeNameToBeginEndIndexesOfCenters[1]);
            }
            Integer n = i;
            i = i + 1;
        }
    }
}

