/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.recurringdeposit;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.EnumOptionDataIdSerializer;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.savings.data.RecurringDepositAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.data.SavingsActivation;
import org.apache.fineract.portfolio.savings.data.SavingsApproval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecurringDepositImportHandler
implements ImportHandler {
    public static final String WEEKS = "Weeks";
    public static final String DAYS = "Days";
    public static final String MONTHS = "Months";
    public static final String YEARS = "Years";
    private static final Logger LOG = LoggerFactory.getLogger(RecurringDepositImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public RecurringDepositImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList savings = new ArrayList();
        ArrayList approvalDates = new ArrayList();
        ArrayList activationDates = new ArrayList();
        ArrayList statuses = new ArrayList();
        this.readExcelFile(workbook, savings, approvalDates, activationDates, statuses, locale, dateFormat);
        return this.importEntity(workbook, savings, approvalDates, activationDates, statuses, dateFormat);
    }

    private void readExcelFile(Workbook workbook, List<RecurringDepositAccountData> savings, List<SavingsApproval> approvalDates, List<SavingsActivation> activationDates, List<String> statuses, String locale, String dateFormat) {
        Sheet savingsSheet = workbook.getSheet("RecurringDeposit");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)savingsSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = savingsSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)24)) continue;
            savings.add(this.readSavings(workbook, row, statuses, locale, dateFormat));
            approvalDates.add(this.readSavingsApproval(row, locale, dateFormat));
            activationDates.add(this.readSavingsActivation(row, locale, dateFormat));
        }
    }

    private SavingsActivation readSavingsActivation(Row row, String locale, String dateFormat) {
        LocalDate activationDate = ImportHandlerUtils.readAsDate((int)6, (Row)row);
        if (activationDate != null) {
            return SavingsActivation.importInstance((LocalDate)activationDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private SavingsApproval readSavingsApproval(Row row, String locale, String dateFormat) {
        LocalDate approvalDate = ImportHandlerUtils.readAsDate((int)5, (Row)row);
        if (approvalDate != null) {
            return SavingsApproval.importInstance((LocalDate)approvalDate, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return null;
    }

    private RecurringDepositAccountData readSavings(Workbook workbook, Row row, List<String> statuses, String locale, String dateFormat) {
        String productName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        Long productId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Products"), (String)productName);
        String fieldOfficerName = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Long fieldOfficerId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)fieldOfficerName);
        LocalDate submittedOnDate = ImportHandlerUtils.readAsDate((int)4, (Row)row);
        String interestCompoundingPeriodType = ImportHandlerUtils.readAsString((int)7, (Row)row);
        Long interestCompoundingPeriodTypeId = null;
        EnumOptionData interestCompoundingPeriodTypeEnum = null;
        if (interestCompoundingPeriodType != null) {
            if (interestCompoundingPeriodType.equalsIgnoreCase("Daily")) {
                interestCompoundingPeriodTypeId = 1L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Monthly")) {
                interestCompoundingPeriodTypeId = 4L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Quarterly")) {
                interestCompoundingPeriodTypeId = 5L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Semi-Annual")) {
                interestCompoundingPeriodTypeId = 6L;
            } else if (interestCompoundingPeriodType.equalsIgnoreCase("Annually")) {
                interestCompoundingPeriodTypeId = 7L;
            }
            interestCompoundingPeriodTypeEnum = new EnumOptionData(interestCompoundingPeriodTypeId, null, null);
        }
        String interestPostingPeriodType = ImportHandlerUtils.readAsString((int)8, (Row)row);
        Long interestPostingPeriodTypeId = null;
        EnumOptionData interestPostingPeriodTypeEnum = null;
        if (interestPostingPeriodType != null) {
            if (interestPostingPeriodType.equalsIgnoreCase("Monthly")) {
                interestPostingPeriodTypeId = 4L;
            } else if (interestPostingPeriodType.equalsIgnoreCase("Quarterly")) {
                interestPostingPeriodTypeId = 5L;
            } else if (interestPostingPeriodType.equalsIgnoreCase("Annually")) {
                interestPostingPeriodTypeId = 7L;
            } else if (interestPostingPeriodType.equalsIgnoreCase("BiAnnual")) {
                interestPostingPeriodTypeId = 6L;
            }
            interestPostingPeriodTypeEnum = new EnumOptionData(interestPostingPeriodTypeId, null, null);
        }
        String interestCalculationType = ImportHandlerUtils.readAsString((int)9, (Row)row);
        Long interestCalculationTypeId = null;
        EnumOptionData interestCalculationTypeEnum = null;
        if (interestCalculationType != null) {
            if (interestCalculationType.equalsIgnoreCase("Daily Balance")) {
                interestCalculationTypeId = 1L;
            } else if (interestCalculationType.equalsIgnoreCase("Average Daily Balance")) {
                interestCalculationTypeId = 2L;
            }
            interestCalculationTypeEnum = new EnumOptionData(interestCalculationTypeId, null, null);
        }
        String interestCalculationDaysInYearType = ImportHandlerUtils.readAsString((int)10, (Row)row);
        EnumOptionData interestCalculationDaysInYearTypeEnum = null;
        Long interestCalculationDaysInYearTypeId = null;
        if (interestCalculationDaysInYearType != null) {
            if (interestCalculationDaysInYearType.equalsIgnoreCase("360 Days")) {
                interestCalculationDaysInYearTypeId = 360L;
            } else if (interestCalculationDaysInYearType.equalsIgnoreCase("365 Days")) {
                interestCalculationDaysInYearTypeId = 365L;
            }
            interestCalculationDaysInYearTypeEnum = new EnumOptionData(interestCalculationDaysInYearTypeId, null, null);
        }
        Integer lockinPeriodFrequency = ImportHandlerUtils.readAsInt((int)11, (Row)row);
        String lockinPeriodFrequencyType = ImportHandlerUtils.readAsString((int)12, (Row)row);
        Long lockinPeriodFrequencyTypeId = null;
        EnumOptionData lockinPeriodFrequencyTypeEnum = null;
        if (lockinPeriodFrequencyType != null) {
            if (lockinPeriodFrequencyType.equalsIgnoreCase(DAYS)) {
                lockinPeriodFrequencyTypeId = 0L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase(WEEKS)) {
                lockinPeriodFrequencyTypeId = 1L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase(MONTHS)) {
                lockinPeriodFrequencyTypeId = 2L;
            } else if (lockinPeriodFrequencyType.equalsIgnoreCase(YEARS)) {
                lockinPeriodFrequencyTypeId = 3L;
            }
            lockinPeriodFrequencyTypeEnum = new EnumOptionData(lockinPeriodFrequencyTypeId, null, null);
        }
        BigDecimal depositAmount = null;
        if (ImportHandlerUtils.readAsDouble((int)13, (Row)row) != null) {
            depositAmount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)13, (Row)row));
        }
        Integer depositPeriod = ImportHandlerUtils.readAsInt((int)14, (Row)row);
        String depositPeriodFrequency = ImportHandlerUtils.readAsString((int)15, (Row)row);
        Long depositPeriodFrequencyId = null;
        if (depositPeriodFrequency != null) {
            if (depositPeriodFrequency.equalsIgnoreCase(DAYS)) {
                depositPeriodFrequencyId = 0L;
            } else if (depositPeriodFrequency.equalsIgnoreCase(WEEKS)) {
                depositPeriodFrequencyId = 1L;
            } else if (depositPeriodFrequency.equalsIgnoreCase(MONTHS)) {
                depositPeriodFrequencyId = 2L;
            } else if (depositPeriodFrequency.equalsIgnoreCase(YEARS)) {
                depositPeriodFrequencyId = 3L;
            }
        }
        Integer recurringFrequency = ImportHandlerUtils.readAsInt((int)16, (Row)row);
        String recurringFrequencyType = ImportHandlerUtils.readAsString((int)17, (Row)row);
        Long recurringFrequencyTypeId = null;
        EnumOptionData recurringFrequencyTypeEnum = null;
        if (recurringFrequencyType != null) {
            if (recurringFrequencyType.equalsIgnoreCase(DAYS)) {
                recurringFrequencyTypeId = 0L;
            } else if (recurringFrequencyType.equalsIgnoreCase(WEEKS)) {
                recurringFrequencyTypeId = 1L;
            } else if (recurringFrequencyType.equalsIgnoreCase(MONTHS)) {
                recurringFrequencyTypeId = 2L;
            } else if (recurringFrequencyType.equalsIgnoreCase(YEARS)) {
                recurringFrequencyTypeId = 3L;
            }
            recurringFrequencyTypeEnum = new EnumOptionData(recurringFrequencyTypeId, null, null);
        }
        LocalDate depositStartDate = ImportHandlerUtils.readAsDate((int)18, (Row)row);
        Boolean allowWithdrawal = ImportHandlerUtils.readAsBoolean((int)20, (Row)row);
        Boolean isMandatoryDeposit = ImportHandlerUtils.readAsBoolean((int)19, (Row)row);
        Boolean inheritCalendar = ImportHandlerUtils.readAsBoolean((int)21, (Row)row);
        Boolean adjustAdvancePayments = ImportHandlerUtils.readAsBoolean((int)22, (Row)row);
        String clientName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        String externalId = ImportHandlerUtils.readAsString((int)23, (Row)row);
        ArrayList<SavingsAccountChargeData> charges = new ArrayList<SavingsAccountChargeData>();
        String charge1 = ImportHandlerUtils.readAsString((int)28, (Row)row);
        String charge2 = ImportHandlerUtils.readAsString((int)33, (Row)row);
        if (charge1 != null) {
            if (ImportHandlerUtils.readAsDouble((int)29, (Row)row) != null) {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)28, (Row)row), BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)29, (Row)row)), ImportHandlerUtils.readAsDate((int)30, (Row)row)));
            } else {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)28, (Row)row), null, ImportHandlerUtils.readAsDate((int)30, (Row)row)));
            }
        }
        if (charge2 != null) {
            if (ImportHandlerUtils.readAsDouble((int)34, (Row)row) != null) {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)33, (Row)row), BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)34, (Row)row)), ImportHandlerUtils.readAsDate((int)35, (Row)row)));
            } else {
                charges.add(new SavingsAccountChargeData(ImportHandlerUtils.readAsLong((int)33, (Row)row), null, ImportHandlerUtils.readAsDate((int)35, (Row)row)));
            }
        }
        String status = ImportHandlerUtils.readAsString((int)24, (Row)row);
        statuses.add(status);
        Long clientId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientName);
        return RecurringDepositAccountData.importInstance((Long)clientId, (Long)productId, (Long)fieldOfficerId, (LocalDate)submittedOnDate, (EnumOptionData)interestCompoundingPeriodTypeEnum, (EnumOptionData)interestPostingPeriodTypeEnum, (EnumOptionData)interestCalculationTypeEnum, (EnumOptionData)interestCalculationDaysInYearTypeEnum, (Integer)lockinPeriodFrequency, (EnumOptionData)lockinPeriodFrequencyTypeEnum, (BigDecimal)depositAmount, (Integer)depositPeriod, (Long)depositPeriodFrequencyId, (LocalDate)depositStartDate, (Integer)recurringFrequency, (EnumOptionData)recurringFrequencyTypeEnum, (boolean)inheritCalendar, (boolean)isMandatoryDeposit, (boolean)allowWithdrawal, (boolean)adjustAdvancePayments, (String)externalId, charges, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<RecurringDepositAccountData> savings, List<SavingsApproval> approvalDates, List<SavingsActivation> activationDates, List<String> statuses, String dateFormat) {
        Sheet savingsSheet = workbook.getSheet("RecurringDeposit");
        int successCount = 0;
        int errorCount = 0;
        int progressLevel = 0;
        Long savingsId = null;
        String errorMessage = "";
        for (int i = 0; i < savings.size(); ++i) {
            Row row = savingsSheet.getRow(savings.get(i).getRowIndex().intValue());
            Cell statusCell = row.createCell(24);
            Cell errorReportCell = row.createCell(26);
            try {
                String status = statuses.get(i);
                progressLevel = this.getProgressLevel(status);
                if (progressLevel == 0) {
                    CommandProcessingResult result = this.importSavings(savings, i, dateFormat);
                    savingsId = result.getSavingsId();
                    progressLevel = 1;
                } else {
                    savingsId = ImportHandlerUtils.readAsLong((int)25, (Row)savingsSheet.getRow(savings.get(i).getRowIndex().intValue()));
                }
                if (progressLevel <= 1) {
                    progressLevel = this.importSavingsApproval(approvalDates, savingsId, i, dateFormat);
                }
                if (progressLevel <= 2) {
                    progressLevel = this.importSavingsActivation(activationDates, savingsId, i, dateFormat);
                }
                ++successCount;
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                continue;
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                this.writeRecurringDepositErrorMessage(workbook, savingsId, errorMessage, progressLevel, statusCell, errorReportCell, row);
            }
        }
        this.setReportHeaders(savingsSheet);
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    private void writeRecurringDepositErrorMessage(Workbook workbook, Long savingsId, String errorMessage, int progressLevel, Cell statusCell, Cell errorReportCell, Row row) {
        String status = "";
        if (progressLevel == 0) {
            status = "Creation failed";
        } else if (progressLevel == 1) {
            status = "Approval failed";
        } else if (progressLevel == 2) {
            status = "Activation failed";
        }
        statusCell.setCellValue(status);
        statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.RED));
        if (progressLevel > 0) {
            row.createCell(25).setCellValue((double)savingsId.longValue());
        }
        errorReportCell.setCellValue(errorMessage);
    }

    private void setReportHeaders(Sheet savingsSheet) {
        savingsSheet.setColumnWidth(24, 4000);
        Row rowHeader = savingsSheet.getRow(0);
        ImportHandlerUtils.writeString((int)24, (Row)rowHeader, (String)"Status");
        ImportHandlerUtils.writeString((int)25, (Row)rowHeader, (String)"Savings ID");
        ImportHandlerUtils.writeString((int)26, (Row)rowHeader, (String)"Report");
    }

    private int importSavingsActivation(List<SavingsActivation> activationDates, Long savingsId, int i, String dateFormat) {
        if (activationDates.get(i) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
            String payload = gsonBuilder.create().toJson((Object)activationDates.get(i));
            CommandWrapper commandRequest = new CommandWrapperBuilder().recurringDepositAccountActivation(savingsId).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 3;
    }

    private int importSavingsApproval(List<SavingsApproval> approvalDates, Long savingsId, int i, String dateFormat) {
        if (approvalDates.get(i) != null) {
            GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
            String payload = gsonBuilder.create().toJson((Object)approvalDates.get(i));
            CommandWrapper commandRequest = new CommandWrapperBuilder().approveRecurringDepositAccountApplication(savingsId).withJson(payload).build();
            this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return 2;
    }

    private CommandProcessingResult importSavings(List<RecurringDepositAccountData> savings, int i, String dateFormat) {
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        gsonBuilder.registerTypeAdapter(EnumOptionData.class, (Object)new EnumOptionDataIdSerializer());
        JsonObject savingsJsonob = gsonBuilder.create().toJsonTree((Object)savings.get(i)).getAsJsonObject();
        savingsJsonob.remove("withdrawalFeeForTransfers");
        String payload = savingsJsonob.toString();
        CommandWrapper commandRequest = new CommandWrapperBuilder().createRecurringDepositAccount().withJson(payload).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private int getProgressLevel(String status) {
        if (status == null || status.equals("Creation failed")) {
            return 0;
        }
        if (status.equals("Approval failed")) {
            return 1;
        }
        if (status.equals("Activation failed")) {
            return 2;
        }
        return 0;
    }
}

