/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.guarantor;

import com.google.common.base.Splitter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.loanaccount.guarantor.data.GuarantorData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GuarantorImportHandler
implements ImportHandler {
    public static final String SEPARATOR = "-";
    private static final Logger LOG = LoggerFactory.getLogger(GuarantorImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public GuarantorImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List guarantors = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, guarantors, dateFormat);
    }

    private List<GuarantorData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<GuarantorData> guarantors = new ArrayList<GuarantorData>();
        Sheet addGuarantorSheet = workbook.getSheet("guarantor");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)addGuarantorSheet, (int)2);
        Long loanAccountId = null;
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = addGuarantorSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)18)) continue;
            guarantors.add(this.readGuarantor(workbook, row, loanAccountId, locale, dateFormat));
        }
        return guarantors;
    }

    private GuarantorData readGuarantor(Workbook workbook, Row row, Long loanAccountId, String locale, String dateFormat) {
        String loanaccountInfo = ImportHandlerUtils.readAsString((int)2, (Row)row);
        if (loanaccountInfo != null) {
            List loanAccountAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)loanaccountInfo);
            loanAccountId = Long.parseLong((String)loanAccountAr.get(0));
        }
        String guarantorType = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Integer guarantorTypeId = null;
        if (guarantorType != null) {
            if (guarantorType.equalsIgnoreCase("Internal")) {
                guarantorTypeId = 1;
            } else if (guarantorType.equalsIgnoreCase("External")) {
                guarantorTypeId = 3;
            }
        }
        String clientName = ImportHandlerUtils.readAsString((int)6, (Row)row);
        Long entityId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientName);
        String clientRelationshipTypeInfo = ImportHandlerUtils.readAsString((int)4, (Row)row);
        Integer clientRelationshipTypeId = null;
        if (clientRelationshipTypeInfo != null) {
            List clientRelationshipTypeAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)clientRelationshipTypeInfo);
            clientRelationshipTypeId = Integer.parseInt((String)clientRelationshipTypeAr.get(1));
        }
        String firstname = ImportHandlerUtils.readAsString((int)7, (Row)row);
        String lastname = ImportHandlerUtils.readAsString((int)8, (Row)row);
        String addressLine1 = ImportHandlerUtils.readAsString((int)9, (Row)row);
        String addressLine2 = ImportHandlerUtils.readAsString((int)10, (Row)row);
        String city = ImportHandlerUtils.readAsString((int)11, (Row)row);
        LocalDate dob = ImportHandlerUtils.readAsDate((int)12, (Row)row);
        String zip = ImportHandlerUtils.readAsString((int)13, (Row)row);
        Integer savingsId = ImportHandlerUtils.readAsInt((int)14, (Row)row);
        BigDecimal amount = BigDecimal.valueOf(ImportHandlerUtils.readAsDouble((int)15, (Row)row));
        return GuarantorData.importInstance((Integer)guarantorTypeId, (Integer)clientRelationshipTypeId, (Long)entityId, (String)firstname, (String)lastname, (String)addressLine1, (String)addressLine2, (String)city, (LocalDate)dob, (String)zip, (Integer)savingsId, (BigDecimal)amount, (Integer)row.getRowNum(), (Long)loanAccountId, (String)locale, (String)dateFormat);
    }

    private Count importEntity(Workbook workbook, List<GuarantorData> guarantors, String dateFormat) {
        Sheet addGuarantorSheet = workbook.getSheet("guarantor");
        int successCount = 0;
        int errorCount = 0;
        String errorMessage = "";
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        for (GuarantorData guarantor : guarantors) {
            try {
                JsonObject guarantorJsonob = gsonBuilder.create().toJsonTree((Object)guarantor).getAsJsonObject();
                guarantorJsonob.remove("status");
                String payload = guarantorJsonob.toString();
                CommandWrapper commandRequest = new CommandWrapperBuilder().createGuarantor(guarantor.getAccountId()).withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = addGuarantorSheet.getRow(guarantor.getRowIndex().intValue()).createCell(18);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)addGuarantorSheet, (Integer)guarantor.getRowIndex(), (String)errorMessage, (int)18);
            }
        }
        addGuarantorSheet.setColumnWidth(18, 4000);
        ImportHandlerUtils.writeString((int)18, (Row)addGuarantorSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

