/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.ClientData;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.OfficeData;
import org.apache.fineract.client.models.PortfolioAccountData;

/**
 * AccountTransferData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class AccountTransferData {
  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT = "fromAccount";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT)
  private PortfolioAccountData fromAccount;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT_OPTIONS = "fromAccountOptions";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT_OPTIONS)
  private List<PortfolioAccountData> fromAccountOptions;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT_TYPE = "fromAccountType";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT_TYPE)
  private EnumOptionData fromAccountType;

  public static final String SERIALIZED_NAME_FROM_ACCOUNT_TYPE_OPTIONS = "fromAccountTypeOptions";
  @SerializedName(SERIALIZED_NAME_FROM_ACCOUNT_TYPE_OPTIONS)
  private List<EnumOptionData> fromAccountTypeOptions;

  public static final String SERIALIZED_NAME_FROM_CLIENT = "fromClient";
  @SerializedName(SERIALIZED_NAME_FROM_CLIENT)
  private ClientData fromClient;

  public static final String SERIALIZED_NAME_FROM_CLIENT_OPTIONS = "fromClientOptions";
  @SerializedName(SERIALIZED_NAME_FROM_CLIENT_OPTIONS)
  private List<ClientData> fromClientOptions;

  public static final String SERIALIZED_NAME_FROM_OFFICE = "fromOffice";
  @SerializedName(SERIALIZED_NAME_FROM_OFFICE)
  private OfficeData fromOffice;

  public static final String SERIALIZED_NAME_FROM_OFFICE_OPTIONS = "fromOfficeOptions";
  @SerializedName(SERIALIZED_NAME_FROM_OFFICE_OPTIONS)
  private List<OfficeData> fromOfficeOptions;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_REVERSED = "reversed";
  @SerializedName(SERIALIZED_NAME_REVERSED)
  private Boolean reversed;

  public static final String SERIALIZED_NAME_TO_ACCOUNT = "toAccount";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT)
  private PortfolioAccountData toAccount;

  public static final String SERIALIZED_NAME_TO_ACCOUNT_OPTIONS = "toAccountOptions";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT_OPTIONS)
  private List<PortfolioAccountData> toAccountOptions;

  public static final String SERIALIZED_NAME_TO_ACCOUNT_TYPE = "toAccountType";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT_TYPE)
  private EnumOptionData toAccountType;

  public static final String SERIALIZED_NAME_TO_ACCOUNT_TYPE_OPTIONS = "toAccountTypeOptions";
  @SerializedName(SERIALIZED_NAME_TO_ACCOUNT_TYPE_OPTIONS)
  private List<EnumOptionData> toAccountTypeOptions;

  public static final String SERIALIZED_NAME_TO_CLIENT = "toClient";
  @SerializedName(SERIALIZED_NAME_TO_CLIENT)
  private ClientData toClient;

  public static final String SERIALIZED_NAME_TO_CLIENT_OPTIONS = "toClientOptions";
  @SerializedName(SERIALIZED_NAME_TO_CLIENT_OPTIONS)
  private List<ClientData> toClientOptions;

  public static final String SERIALIZED_NAME_TO_OFFICE = "toOffice";
  @SerializedName(SERIALIZED_NAME_TO_OFFICE)
  private OfficeData toOffice;

  public static final String SERIALIZED_NAME_TO_OFFICE_OPTIONS = "toOfficeOptions";
  @SerializedName(SERIALIZED_NAME_TO_OFFICE_OPTIONS)
  private List<OfficeData> toOfficeOptions;

  public static final String SERIALIZED_NAME_TRANSFER_AMOUNT = "transferAmount";
  @SerializedName(SERIALIZED_NAME_TRANSFER_AMOUNT)
  private BigDecimal transferAmount;

  public static final String SERIALIZED_NAME_TRANSFER_DATE = "transferDate";
  @SerializedName(SERIALIZED_NAME_TRANSFER_DATE)
  private LocalDate transferDate;

  public static final String SERIALIZED_NAME_TRANSFER_DESCRIPTION = "transferDescription";
  @SerializedName(SERIALIZED_NAME_TRANSFER_DESCRIPTION)
  private String transferDescription;

  public AccountTransferData() {
  }

  public AccountTransferData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public AccountTransferData fromAccount(PortfolioAccountData fromAccount) {
    
    this.fromAccount = fromAccount;
    return this;
  }

  /**
   * Get fromAccount
   * @return fromAccount
   */
  @javax.annotation.Nullable

  public PortfolioAccountData getFromAccount() {
    return fromAccount;
  }


  public void setFromAccount(PortfolioAccountData fromAccount) {
    this.fromAccount = fromAccount;
  }

  public AccountTransferData fromAccountOptions(List<PortfolioAccountData> fromAccountOptions) {
    
    this.fromAccountOptions = fromAccountOptions;
    return this;
  }

  public AccountTransferData addFromAccountOptionsItem(PortfolioAccountData fromAccountOptionsItem) {
    if (this.fromAccountOptions == null) {
      this.fromAccountOptions = new ArrayList<>();
    }
    this.fromAccountOptions.add(fromAccountOptionsItem);
    return this;
  }

  /**
   * Get fromAccountOptions
   * @return fromAccountOptions
   */
  @javax.annotation.Nullable

  public List<PortfolioAccountData> getFromAccountOptions() {
    return fromAccountOptions;
  }


  public void setFromAccountOptions(List<PortfolioAccountData> fromAccountOptions) {
    this.fromAccountOptions = fromAccountOptions;
  }

  public AccountTransferData fromAccountType(EnumOptionData fromAccountType) {
    
    this.fromAccountType = fromAccountType;
    return this;
  }

  /**
   * Get fromAccountType
   * @return fromAccountType
   */
  @javax.annotation.Nullable

  public EnumOptionData getFromAccountType() {
    return fromAccountType;
  }


  public void setFromAccountType(EnumOptionData fromAccountType) {
    this.fromAccountType = fromAccountType;
  }

  public AccountTransferData fromAccountTypeOptions(List<EnumOptionData> fromAccountTypeOptions) {
    
    this.fromAccountTypeOptions = fromAccountTypeOptions;
    return this;
  }

  public AccountTransferData addFromAccountTypeOptionsItem(EnumOptionData fromAccountTypeOptionsItem) {
    if (this.fromAccountTypeOptions == null) {
      this.fromAccountTypeOptions = new ArrayList<>();
    }
    this.fromAccountTypeOptions.add(fromAccountTypeOptionsItem);
    return this;
  }

  /**
   * Get fromAccountTypeOptions
   * @return fromAccountTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getFromAccountTypeOptions() {
    return fromAccountTypeOptions;
  }


  public void setFromAccountTypeOptions(List<EnumOptionData> fromAccountTypeOptions) {
    this.fromAccountTypeOptions = fromAccountTypeOptions;
  }

  public AccountTransferData fromClient(ClientData fromClient) {
    
    this.fromClient = fromClient;
    return this;
  }

  /**
   * Get fromClient
   * @return fromClient
   */
  @javax.annotation.Nullable

  public ClientData getFromClient() {
    return fromClient;
  }


  public void setFromClient(ClientData fromClient) {
    this.fromClient = fromClient;
  }

  public AccountTransferData fromClientOptions(List<ClientData> fromClientOptions) {
    
    this.fromClientOptions = fromClientOptions;
    return this;
  }

  public AccountTransferData addFromClientOptionsItem(ClientData fromClientOptionsItem) {
    if (this.fromClientOptions == null) {
      this.fromClientOptions = new ArrayList<>();
    }
    this.fromClientOptions.add(fromClientOptionsItem);
    return this;
  }

  /**
   * Get fromClientOptions
   * @return fromClientOptions
   */
  @javax.annotation.Nullable

  public List<ClientData> getFromClientOptions() {
    return fromClientOptions;
  }


  public void setFromClientOptions(List<ClientData> fromClientOptions) {
    this.fromClientOptions = fromClientOptions;
  }

  public AccountTransferData fromOffice(OfficeData fromOffice) {
    
    this.fromOffice = fromOffice;
    return this;
  }

  /**
   * Get fromOffice
   * @return fromOffice
   */
  @javax.annotation.Nullable

  public OfficeData getFromOffice() {
    return fromOffice;
  }


  public void setFromOffice(OfficeData fromOffice) {
    this.fromOffice = fromOffice;
  }

  public AccountTransferData fromOfficeOptions(List<OfficeData> fromOfficeOptions) {
    
    this.fromOfficeOptions = fromOfficeOptions;
    return this;
  }

  public AccountTransferData addFromOfficeOptionsItem(OfficeData fromOfficeOptionsItem) {
    if (this.fromOfficeOptions == null) {
      this.fromOfficeOptions = new ArrayList<>();
    }
    this.fromOfficeOptions.add(fromOfficeOptionsItem);
    return this;
  }

  /**
   * Get fromOfficeOptions
   * @return fromOfficeOptions
   */
  @javax.annotation.Nullable

  public List<OfficeData> getFromOfficeOptions() {
    return fromOfficeOptions;
  }


  public void setFromOfficeOptions(List<OfficeData> fromOfficeOptions) {
    this.fromOfficeOptions = fromOfficeOptions;
  }

  public AccountTransferData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public AccountTransferData reversed(Boolean reversed) {
    
    this.reversed = reversed;
    return this;
  }

  /**
   * Get reversed
   * @return reversed
   */
  @javax.annotation.Nullable

  public Boolean getReversed() {
    return reversed;
  }


  public void setReversed(Boolean reversed) {
    this.reversed = reversed;
  }

  public AccountTransferData toAccount(PortfolioAccountData toAccount) {
    
    this.toAccount = toAccount;
    return this;
  }

  /**
   * Get toAccount
   * @return toAccount
   */
  @javax.annotation.Nullable

  public PortfolioAccountData getToAccount() {
    return toAccount;
  }


  public void setToAccount(PortfolioAccountData toAccount) {
    this.toAccount = toAccount;
  }

  public AccountTransferData toAccountOptions(List<PortfolioAccountData> toAccountOptions) {
    
    this.toAccountOptions = toAccountOptions;
    return this;
  }

  public AccountTransferData addToAccountOptionsItem(PortfolioAccountData toAccountOptionsItem) {
    if (this.toAccountOptions == null) {
      this.toAccountOptions = new ArrayList<>();
    }
    this.toAccountOptions.add(toAccountOptionsItem);
    return this;
  }

  /**
   * Get toAccountOptions
   * @return toAccountOptions
   */
  @javax.annotation.Nullable

  public List<PortfolioAccountData> getToAccountOptions() {
    return toAccountOptions;
  }


  public void setToAccountOptions(List<PortfolioAccountData> toAccountOptions) {
    this.toAccountOptions = toAccountOptions;
  }

  public AccountTransferData toAccountType(EnumOptionData toAccountType) {
    
    this.toAccountType = toAccountType;
    return this;
  }

  /**
   * Get toAccountType
   * @return toAccountType
   */
  @javax.annotation.Nullable

  public EnumOptionData getToAccountType() {
    return toAccountType;
  }


  public void setToAccountType(EnumOptionData toAccountType) {
    this.toAccountType = toAccountType;
  }

  public AccountTransferData toAccountTypeOptions(List<EnumOptionData> toAccountTypeOptions) {
    
    this.toAccountTypeOptions = toAccountTypeOptions;
    return this;
  }

  public AccountTransferData addToAccountTypeOptionsItem(EnumOptionData toAccountTypeOptionsItem) {
    if (this.toAccountTypeOptions == null) {
      this.toAccountTypeOptions = new ArrayList<>();
    }
    this.toAccountTypeOptions.add(toAccountTypeOptionsItem);
    return this;
  }

  /**
   * Get toAccountTypeOptions
   * @return toAccountTypeOptions
   */
  @javax.annotation.Nullable

  public List<EnumOptionData> getToAccountTypeOptions() {
    return toAccountTypeOptions;
  }


  public void setToAccountTypeOptions(List<EnumOptionData> toAccountTypeOptions) {
    this.toAccountTypeOptions = toAccountTypeOptions;
  }

  public AccountTransferData toClient(ClientData toClient) {
    
    this.toClient = toClient;
    return this;
  }

  /**
   * Get toClient
   * @return toClient
   */
  @javax.annotation.Nullable

  public ClientData getToClient() {
    return toClient;
  }


  public void setToClient(ClientData toClient) {
    this.toClient = toClient;
  }

  public AccountTransferData toClientOptions(List<ClientData> toClientOptions) {
    
    this.toClientOptions = toClientOptions;
    return this;
  }

  public AccountTransferData addToClientOptionsItem(ClientData toClientOptionsItem) {
    if (this.toClientOptions == null) {
      this.toClientOptions = new ArrayList<>();
    }
    this.toClientOptions.add(toClientOptionsItem);
    return this;
  }

  /**
   * Get toClientOptions
   * @return toClientOptions
   */
  @javax.annotation.Nullable

  public List<ClientData> getToClientOptions() {
    return toClientOptions;
  }


  public void setToClientOptions(List<ClientData> toClientOptions) {
    this.toClientOptions = toClientOptions;
  }

  public AccountTransferData toOffice(OfficeData toOffice) {
    
    this.toOffice = toOffice;
    return this;
  }

  /**
   * Get toOffice
   * @return toOffice
   */
  @javax.annotation.Nullable

  public OfficeData getToOffice() {
    return toOffice;
  }


  public void setToOffice(OfficeData toOffice) {
    this.toOffice = toOffice;
  }

  public AccountTransferData toOfficeOptions(List<OfficeData> toOfficeOptions) {
    
    this.toOfficeOptions = toOfficeOptions;
    return this;
  }

  public AccountTransferData addToOfficeOptionsItem(OfficeData toOfficeOptionsItem) {
    if (this.toOfficeOptions == null) {
      this.toOfficeOptions = new ArrayList<>();
    }
    this.toOfficeOptions.add(toOfficeOptionsItem);
    return this;
  }

  /**
   * Get toOfficeOptions
   * @return toOfficeOptions
   */
  @javax.annotation.Nullable

  public List<OfficeData> getToOfficeOptions() {
    return toOfficeOptions;
  }


  public void setToOfficeOptions(List<OfficeData> toOfficeOptions) {
    this.toOfficeOptions = toOfficeOptions;
  }

  public AccountTransferData transferAmount(BigDecimal transferAmount) {
    
    this.transferAmount = transferAmount;
    return this;
  }

  /**
   * Get transferAmount
   * @return transferAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getTransferAmount() {
    return transferAmount;
  }


  public void setTransferAmount(BigDecimal transferAmount) {
    this.transferAmount = transferAmount;
  }

  public AccountTransferData transferDate(LocalDate transferDate) {
    
    this.transferDate = transferDate;
    return this;
  }

  /**
   * Get transferDate
   * @return transferDate
   */
  @javax.annotation.Nullable

  public LocalDate getTransferDate() {
    return transferDate;
  }


  public void setTransferDate(LocalDate transferDate) {
    this.transferDate = transferDate;
  }

  public AccountTransferData transferDescription(String transferDescription) {
    
    this.transferDescription = transferDescription;
    return this;
  }

  /**
   * Get transferDescription
   * @return transferDescription
   */
  @javax.annotation.Nullable

  public String getTransferDescription() {
    return transferDescription;
  }


  public void setTransferDescription(String transferDescription) {
    this.transferDescription = transferDescription;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountTransferData accountTransferData = (AccountTransferData) o;
    return Objects.equals(this.currency, accountTransferData.currency) &&
        Objects.equals(this.fromAccount, accountTransferData.fromAccount) &&
        Objects.equals(this.fromAccountOptions, accountTransferData.fromAccountOptions) &&
        Objects.equals(this.fromAccountType, accountTransferData.fromAccountType) &&
        Objects.equals(this.fromAccountTypeOptions, accountTransferData.fromAccountTypeOptions) &&
        Objects.equals(this.fromClient, accountTransferData.fromClient) &&
        Objects.equals(this.fromClientOptions, accountTransferData.fromClientOptions) &&
        Objects.equals(this.fromOffice, accountTransferData.fromOffice) &&
        Objects.equals(this.fromOfficeOptions, accountTransferData.fromOfficeOptions) &&
        Objects.equals(this.id, accountTransferData.id) &&
        Objects.equals(this.reversed, accountTransferData.reversed) &&
        Objects.equals(this.toAccount, accountTransferData.toAccount) &&
        Objects.equals(this.toAccountOptions, accountTransferData.toAccountOptions) &&
        Objects.equals(this.toAccountType, accountTransferData.toAccountType) &&
        Objects.equals(this.toAccountTypeOptions, accountTransferData.toAccountTypeOptions) &&
        Objects.equals(this.toClient, accountTransferData.toClient) &&
        Objects.equals(this.toClientOptions, accountTransferData.toClientOptions) &&
        Objects.equals(this.toOffice, accountTransferData.toOffice) &&
        Objects.equals(this.toOfficeOptions, accountTransferData.toOfficeOptions) &&
        Objects.equals(this.transferAmount, accountTransferData.transferAmount) &&
        Objects.equals(this.transferDate, accountTransferData.transferDate) &&
        Objects.equals(this.transferDescription, accountTransferData.transferDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, fromAccount, fromAccountOptions, fromAccountType, fromAccountTypeOptions, fromClient, fromClientOptions, fromOffice, fromOfficeOptions, id, reversed, toAccount, toAccountOptions, toAccountType, toAccountTypeOptions, toClient, toClientOptions, toOffice, toOfficeOptions, transferAmount, transferDate, transferDescription);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountTransferData {\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    fromAccount: ").append(toIndentedString(fromAccount)).append("\n");
    sb.append("    fromAccountOptions: ").append(toIndentedString(fromAccountOptions)).append("\n");
    sb.append("    fromAccountType: ").append(toIndentedString(fromAccountType)).append("\n");
    sb.append("    fromAccountTypeOptions: ").append(toIndentedString(fromAccountTypeOptions)).append("\n");
    sb.append("    fromClient: ").append(toIndentedString(fromClient)).append("\n");
    sb.append("    fromClientOptions: ").append(toIndentedString(fromClientOptions)).append("\n");
    sb.append("    fromOffice: ").append(toIndentedString(fromOffice)).append("\n");
    sb.append("    fromOfficeOptions: ").append(toIndentedString(fromOfficeOptions)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    reversed: ").append(toIndentedString(reversed)).append("\n");
    sb.append("    toAccount: ").append(toIndentedString(toAccount)).append("\n");
    sb.append("    toAccountOptions: ").append(toIndentedString(toAccountOptions)).append("\n");
    sb.append("    toAccountType: ").append(toIndentedString(toAccountType)).append("\n");
    sb.append("    toAccountTypeOptions: ").append(toIndentedString(toAccountTypeOptions)).append("\n");
    sb.append("    toClient: ").append(toIndentedString(toClient)).append("\n");
    sb.append("    toClientOptions: ").append(toIndentedString(toClientOptions)).append("\n");
    sb.append("    toOffice: ").append(toIndentedString(toOffice)).append("\n");
    sb.append("    toOfficeOptions: ").append(toIndentedString(toOfficeOptions)).append("\n");
    sb.append("    transferAmount: ").append(toIndentedString(transferAmount)).append("\n");
    sb.append("    transferDate: ").append(toIndentedString(transferDate)).append("\n");
    sb.append("    transferDescription: ").append(toIndentedString(transferDescription)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

