/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.productmix.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.apache.fineract.portfolio.loanproduct.productmix.domain.ProductMix;
import org.apache.fineract.portfolio.loanproduct.productmix.domain.ProductMixRepository;
import org.apache.fineract.portfolio.loanproduct.productmix.exception.ProductMixNotFoundException;
import org.apache.fineract.portfolio.loanproduct.productmix.serialization.ProductMixDataValidator;
import org.apache.fineract.portfolio.loanproduct.productmix.service.ProductMixWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProductMixWritePlatformServiceJpaRepositoryImpl
implements ProductMixWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(ProductMixWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final ProductMixDataValidator fromApiJsonDeserializer;
    private final ProductMixRepository productMixRepository;
    private final LoanProductRepository productRepository;

    @Autowired
    public ProductMixWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, ProductMixDataValidator fromApiJsonDeserializer, ProductMixRepository productMixRepository, LoanProductRepository productRepository) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.productMixRepository = productMixRepository;
        this.productRepository = productRepository;
    }

    @Transactional
    public CommandProcessingResult createProductMix(Long productId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            HashSet<String> restrictedIds = new HashSet<String>(Arrays.asList(command.arrayValueOfParameterNamed("restrictedProducts")));
            List removedRestrictions = this.updateRestrictionsForProduct(productId, restrictedIds);
            Map restrictedProductsAsMap = this.getRestrictedProducts(restrictedIds);
            ArrayList productMixes = new ArrayList();
            this.createNewProductMix(restrictedProductsAsMap, productId, productMixes);
            this.productMixRepository.saveAll(productMixes);
            LinkedHashMap<String, Collection<Object>> changes = new LinkedHashMap<String, Collection<Object>>();
            changes.put("restrictedProductsForMix", restrictedProductsAsMap.keySet());
            changes.put("removedProductsForMix", removedRestrictions);
            return new CommandProcessingResultBuilder().withProductId(productId).with(changes).withCommandId(command.commandId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues((NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private List<Long> updateRestrictionsForProduct(Long productId, Set<String> restrictedIds) {
        ArrayList<Long> removedRestrictions = new ArrayList<Long>();
        ArrayList<ProductMix> mixesToRemove = new ArrayList<ProductMix>();
        List existedProductMixes = this.productMixRepository.findRestrictedProducts(productId);
        for (ProductMix productMix : existedProductMixes) {
            if (restrictedIds.contains(productMix.getProductId().toString())) continue;
            mixesToRemove.add(productMix);
            removedRestrictions.add((Long)productMix.getId());
        }
        if (!CollectionUtils.isEmpty(mixesToRemove)) {
            this.productMixRepository.deleteAll(mixesToRemove);
        }
        return removedRestrictions;
    }

    private void createNewProductMix(Map<Long, LoanProduct> restrictedProductsAsMap, Long productId, List<ProductMix> productMixes) {
        LoanProduct productMixInstance = this.findByProductIdIfProvided(productId);
        for (LoanProduct restrictedProduct : restrictedProductsAsMap.values()) {
            ProductMix productMix = ProductMix.createNew((LoanProduct)productMixInstance, (LoanProduct)restrictedProduct);
            productMixes.add(productMix);
        }
    }

    public CommandProcessingResult updateProductMix(Long productId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            LinkedHashMap<String, List> changes = new LinkedHashMap<String, List>();
            ArrayList existedProductMixes = new ArrayList(this.productMixRepository.findByProductId(productId));
            if (CollectionUtils.isEmpty(existedProductMixes)) {
                throw new ProductMixNotFoundException(productId);
            }
            HashSet<String> restrictedIds = new HashSet<String>(Arrays.asList(command.arrayValueOfParameterNamed("restrictedProducts")));
            if (restrictedIds.isEmpty()) {
                List removedRestrictedProductIds = this.productMixRepository.findRestrictedProductIdsByProductId(productId);
                this.productMixRepository.deleteAll(existedProductMixes);
                changes.put("removedProductsForMix", removedRestrictedProductIds);
                return new CommandProcessingResultBuilder().with(changes).withProductId(productId).withCommandId(command.commandId()).build();
            }
            List productMixesToRemove = this.updateRestrictedIds(restrictedIds, existedProductMixes);
            Map restrictedProductsAsMap = this.getRestrictedProducts(restrictedIds);
            this.createNewProductMix(restrictedProductsAsMap, productId, existedProductMixes);
            this.productMixRepository.saveAll(existedProductMixes);
            changes.put("restrictedProductsForMix", this.getProductIdsFromCollection(existedProductMixes));
            if (!CollectionUtils.isEmpty((Collection)productMixesToRemove)) {
                this.productMixRepository.deleteAll((Iterable)productMixesToRemove);
                changes.put("removedProductsForMix", this.getProductIdsFromCollection(productMixesToRemove));
            }
            return new CommandProcessingResultBuilder().with(changes).withProductId(productId).withCommandId(command.commandId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues((NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private LoanProduct findByProductIdIfProvided(Long productId) {
        return (LoanProduct)this.productRepository.findById((Object)productId).orElseThrow(() -> new LoanProductNotFoundException(productId));
    }

    private Map<Long, LoanProduct> getRestrictedProducts(Set<String> restrictedIds) {
        HashMap<Long, LoanProduct> restrictedProducts = new HashMap<Long, LoanProduct>();
        for (String restrictedId : restrictedIds) {
            Long restrictedIdAsLong = Long.valueOf(restrictedId);
            LoanProduct restrictedProduct = this.findByProductIdIfProvided(Long.valueOf(restrictedId));
            restrictedProducts.put(restrictedIdAsLong, restrictedProduct);
        }
        return restrictedProducts;
    }

    private void handleDataIntegrityIssues(NonTransientDataAccessException dve) {
        LOG.error("Error occurred.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.product.loan.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    private List<ProductMix> updateRestrictedIds(Set<String> restrictedIds, List<ProductMix> existedProductMixes) {
        ArrayList<ProductMix> productMixesToRemove = new ArrayList<ProductMix>();
        for (ProductMix productMix : existedProductMixes) {
            String currentMixId = productMix.getRestrictedProductId().toString();
            if (restrictedIds.contains(currentMixId)) {
                restrictedIds.remove(currentMixId);
                continue;
            }
            productMixesToRemove.add(productMix);
        }
        existedProductMixes.removeAll(productMixesToRemove);
        return productMixesToRemove;
    }

    public CommandProcessingResult deleteProductMix(Long productId) {
        try {
            this.context.authenticatedUser();
            LinkedHashMap<String, List> changes = new LinkedHashMap<String, List>();
            List existedProductMixes = this.productMixRepository.findByProductId(productId);
            if (CollectionUtils.isEmpty((Collection)existedProductMixes)) {
                throw new ProductMixNotFoundException(productId);
            }
            this.productMixRepository.deleteAll((Iterable)existedProductMixes);
            changes.put("removedProductsForMix", this.getProductIdsFromCollection(existedProductMixes));
            return new CommandProcessingResultBuilder().with(changes).withProductId(productId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues((NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private List<Long> getProductIdsFromCollection(List<ProductMix> collection) {
        ArrayList<Long> productIds = new ArrayList<Long>();
        for (ProductMix productMix : collection) {
            productIds.add(productMix.getRestrictedProductId());
        }
        return productIds;
    }
}

