/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.MonthDay;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetailAssembler;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.account.domain.AccountTransferStandingInstruction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandingInstructionAssembler {
    private final AccountTransferDetailAssembler accountTransferDetailAssembler;

    @Autowired
    public StandingInstructionAssembler(AccountTransferDetailAssembler accountTransferDetailAssembler) {
        this.accountTransferDetailAssembler = accountTransferDetailAssembler;
    }

    public AccountTransferDetails assembleSavingsToSavingsTransfer(JsonCommand command) {
        AccountTransferDetails accountTransferDetails = this.accountTransferDetailAssembler.assembleSavingsToSavingsTransfer(command);
        this.assembleStandingInstruction(command, accountTransferDetails);
        return accountTransferDetails;
    }

    public void assembleStandingInstruction(JsonCommand command, AccountTransferDetails accountTransferDetails) {
        LocalDate validFrom = command.localDateValueOfParameterNamed("validFrom");
        LocalDate validTill = command.localDateValueOfParameterNamed("validTill");
        BigDecimal amount = null;
        BigDecimal transferAmount = command.bigDecimalValueOfParameterNamed("amount");
        if (transferAmount != null) {
            Money monetaryAmount = Money.of((MonetaryCurrency)accountTransferDetails.fromSavingsAccount().getCurrency(), (BigDecimal)transferAmount);
            amount = monetaryAmount.getAmount();
        }
        Integer status = command.integerValueOfParameterNamed("status");
        Integer priority = command.integerValueOfParameterNamed("priority");
        Integer standingInstructionType = command.integerValueOfParameterNamed("instructionType");
        Integer recurrenceType = command.integerValueOfParameterNamed("recurrenceType");
        Integer recurrenceFrequency = command.integerValueOfParameterNamed("recurrenceFrequency");
        MonthDay recurrenceOnMonthDay = command.extractMonthDayNamed("recurrenceOnMonthDay");
        Integer recurrenceInterval = command.integerValueOfParameterNamed("recurrenceInterval");
        String name = command.stringValueOfParameterNamed("name");
        AccountTransferStandingInstruction accountTransferStandingInstruction = AccountTransferStandingInstruction.create((AccountTransferDetails)accountTransferDetails, (String)name, (Integer)priority, (Integer)standingInstructionType, (Integer)status, (BigDecimal)amount, (LocalDate)validFrom, (LocalDate)validTill, (Integer)recurrenceType, (Integer)recurrenceFrequency, (Integer)recurrenceInterval, (MonthDay)recurrenceOnMonthDay);
        accountTransferDetails.updateAccountTransferStandingInstruction(accountTransferStandingInstruction);
    }

    public AccountTransferDetails assembleSavingsToLoanTransfer(JsonCommand command) {
        AccountTransferDetails accountTransferDetails = this.accountTransferDetailAssembler.assembleSavingsToLoanTransfer(command);
        this.assembleStandingInstruction(command, accountTransferDetails);
        return accountTransferDetails;
    }

    public AccountTransferDetails assembleLoanToSavingsTransfer(JsonCommand command) {
        AccountTransferDetails accountTransferDetails = this.accountTransferDetailAssembler.assembleLoanToSavingsTransfer(command);
        this.assembleStandingInstruction(command, accountTransferDetails);
        return accountTransferDetails;
    }
}

