/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RGStreamCutRecord;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class CreateReaderGroupEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final long requestId;
    private final String scope;
    private final String rgName;
    private final long groupRefreshTimeMillis;
    private final long automaticCheckpointIntervalMillis;
    private final int maxOutstandingCheckpointRequest;
    private final int retentionTypeOrdinal;
    private final long generation;
    private final UUID readerGroupId;
    private final Map<String, RGStreamCutRecord> startingStreamCuts;
    private final Map<String, RGStreamCutRecord> endingStreamCuts;
    private final long createTimeStamp;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.rgName);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((StreamRequestProcessor)processor).processCreateReaderGroup(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static CreateReaderGroupEventBuilder builder() {
        return new CreateReaderGroupEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRgName() {
        return this.rgName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGroupRefreshTimeMillis() {
        return this.groupRefreshTimeMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getAutomaticCheckpointIntervalMillis() {
        return this.automaticCheckpointIntervalMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxOutstandingCheckpointRequest() {
        return this.maxOutstandingCheckpointRequest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetentionTypeOrdinal() {
        return this.retentionTypeOrdinal;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getGeneration() {
        return this.generation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getReaderGroupId() {
        return this.readerGroupId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, RGStreamCutRecord> getStartingStreamCuts() {
        return this.startingStreamCuts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, RGStreamCutRecord> getEndingStreamCuts() {
        return this.endingStreamCuts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getCreateTimeStamp() {
        return this.createTimeStamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateReaderGroupEvent)) {
            return false;
        }
        CreateReaderGroupEvent other = (CreateReaderGroupEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$rgName = this.getRgName();
        String other$rgName = other.getRgName();
        if (this$rgName == null ? other$rgName != null : !this$rgName.equals(other$rgName)) {
            return false;
        }
        if (this.getGroupRefreshTimeMillis() != other.getGroupRefreshTimeMillis()) {
            return false;
        }
        if (this.getAutomaticCheckpointIntervalMillis() != other.getAutomaticCheckpointIntervalMillis()) {
            return false;
        }
        if (this.getMaxOutstandingCheckpointRequest() != other.getMaxOutstandingCheckpointRequest()) {
            return false;
        }
        if (this.getRetentionTypeOrdinal() != other.getRetentionTypeOrdinal()) {
            return false;
        }
        if (this.getGeneration() != other.getGeneration()) {
            return false;
        }
        UUID this$readerGroupId = this.getReaderGroupId();
        UUID other$readerGroupId = other.getReaderGroupId();
        if (this$readerGroupId == null ? other$readerGroupId != null : !((Object)this$readerGroupId).equals(other$readerGroupId)) {
            return false;
        }
        Map<String, RGStreamCutRecord> this$startingStreamCuts = this.getStartingStreamCuts();
        Map<String, RGStreamCutRecord> other$startingStreamCuts = other.getStartingStreamCuts();
        if (this$startingStreamCuts == null ? other$startingStreamCuts != null : !((Object)this$startingStreamCuts).equals(other$startingStreamCuts)) {
            return false;
        }
        Map<String, RGStreamCutRecord> this$endingStreamCuts = this.getEndingStreamCuts();
        Map<String, RGStreamCutRecord> other$endingStreamCuts = other.getEndingStreamCuts();
        if (this$endingStreamCuts == null ? other$endingStreamCuts != null : !((Object)this$endingStreamCuts).equals(other$endingStreamCuts)) {
            return false;
        }
        return this.getCreateTimeStamp() == other.getCreateTimeStamp();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateReaderGroupEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $rgName = this.getRgName();
        result = result * 59 + ($rgName == null ? 43 : $rgName.hashCode());
        long $groupRefreshTimeMillis = this.getGroupRefreshTimeMillis();
        result = result * 59 + (int)($groupRefreshTimeMillis >>> 32 ^ $groupRefreshTimeMillis);
        long $automaticCheckpointIntervalMillis = this.getAutomaticCheckpointIntervalMillis();
        result = result * 59 + (int)($automaticCheckpointIntervalMillis >>> 32 ^ $automaticCheckpointIntervalMillis);
        result = result * 59 + this.getMaxOutstandingCheckpointRequest();
        result = result * 59 + this.getRetentionTypeOrdinal();
        long $generation = this.getGeneration();
        result = result * 59 + (int)($generation >>> 32 ^ $generation);
        UUID $readerGroupId = this.getReaderGroupId();
        result = result * 59 + ($readerGroupId == null ? 43 : ((Object)$readerGroupId).hashCode());
        Map<String, RGStreamCutRecord> $startingStreamCuts = this.getStartingStreamCuts();
        result = result * 59 + ($startingStreamCuts == null ? 43 : ((Object)$startingStreamCuts).hashCode());
        Map<String, RGStreamCutRecord> $endingStreamCuts = this.getEndingStreamCuts();
        result = result * 59 + ($endingStreamCuts == null ? 43 : ((Object)$endingStreamCuts).hashCode());
        long $createTimeStamp = this.getCreateTimeStamp();
        result = result * 59 + (int)($createTimeStamp >>> 32 ^ $createTimeStamp);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CreateReaderGroupEvent(requestId=" + this.getRequestId() + ", scope=" + this.getScope() + ", rgName=" + this.getRgName() + ", groupRefreshTimeMillis=" + this.getGroupRefreshTimeMillis() + ", automaticCheckpointIntervalMillis=" + this.getAutomaticCheckpointIntervalMillis() + ", maxOutstandingCheckpointRequest=" + this.getMaxOutstandingCheckpointRequest() + ", retentionTypeOrdinal=" + this.getRetentionTypeOrdinal() + ", generation=" + this.getGeneration() + ", readerGroupId=" + this.getReaderGroupId() + ", startingStreamCuts=" + this.getStartingStreamCuts() + ", endingStreamCuts=" + this.getEndingStreamCuts() + ", createTimeStamp=" + this.getCreateTimeStamp() + ")";
    }

    @ConstructorProperties(value={"requestId", "scope", "rgName", "groupRefreshTimeMillis", "automaticCheckpointIntervalMillis", "maxOutstandingCheckpointRequest", "retentionTypeOrdinal", "generation", "readerGroupId", "startingStreamCuts", "endingStreamCuts", "createTimeStamp"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CreateReaderGroupEvent(long requestId, String scope, String rgName, long groupRefreshTimeMillis, long automaticCheckpointIntervalMillis, int maxOutstandingCheckpointRequest, int retentionTypeOrdinal, long generation, UUID readerGroupId, Map<String, RGStreamCutRecord> startingStreamCuts, Map<String, RGStreamCutRecord> endingStreamCuts, long createTimeStamp) {
        this.requestId = requestId;
        this.scope = scope;
        this.rgName = rgName;
        this.groupRefreshTimeMillis = groupRefreshTimeMillis;
        this.automaticCheckpointIntervalMillis = automaticCheckpointIntervalMillis;
        this.maxOutstandingCheckpointRequest = maxOutstandingCheckpointRequest;
        this.retentionTypeOrdinal = retentionTypeOrdinal;
        this.generation = generation;
        this.readerGroupId = readerGroupId;
        this.startingStreamCuts = startingStreamCuts;
        this.endingStreamCuts = endingStreamCuts;
        this.createTimeStamp = createTimeStamp;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<CreateReaderGroupEvent, CreateReaderGroupEventBuilder> {
        protected CreateReaderGroupEventBuilder newBuilder() {
            return CreateReaderGroupEvent.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(CreateReaderGroupEvent e, RevisionDataOutput target) throws IOException {
            target.writeLong(e.requestId);
            target.writeUTF(e.scope);
            target.writeUTF(e.rgName);
            target.writeLong(e.createTimeStamp);
            target.writeLong(e.groupRefreshTimeMillis);
            target.writeLong(e.automaticCheckpointIntervalMillis);
            target.writeInt(e.maxOutstandingCheckpointRequest);
            target.writeCompactInt(e.retentionTypeOrdinal);
            target.writeLong(e.generation);
            target.writeUUID(e.readerGroupId);
            target.writeMap(e.startingStreamCuts, DataOutput::writeUTF, (arg_0, arg_1) -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).serialize(arg_0, arg_1));
            target.writeMap(e.endingStreamCuts, DataOutput::writeUTF, (arg_0, arg_1) -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).serialize(arg_0, arg_1));
        }

        private void read00(RevisionDataInput source, CreateReaderGroupEventBuilder eb) throws IOException {
            eb.requestId(source.readLong());
            eb.scope(source.readUTF());
            eb.rgName(source.readUTF());
            eb.createTimeStamp(source.readLong());
            eb.groupRefreshTimeMillis(source.readLong());
            eb.automaticCheckpointIntervalMillis(source.readLong());
            eb.maxOutstandingCheckpointRequest(source.readInt());
            eb.retentionTypeOrdinal(source.readCompactInt());
            eb.generation(source.readLong());
            eb.readerGroupId(source.readUUID());
            ImmutableMap.Builder startStreamCutBuilder = ImmutableMap.builder();
            source.readMap(DataInput::readUTF, arg_0 -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).deserialize(arg_0), startStreamCutBuilder);
            eb.startingStreamCuts((Map<String, RGStreamCutRecord>)startStreamCutBuilder.build());
            ImmutableMap.Builder endStreamCutBuilder = ImmutableMap.builder();
            source.readMap(DataInput::readUTF, arg_0 -> ((RGStreamCutRecord.RGStreamCutRecordSerializer)RGStreamCutRecord.SERIALIZER).deserialize(arg_0), endStreamCutBuilder);
            eb.endingStreamCuts((Map<String, RGStreamCutRecord>)endStreamCutBuilder.build());
        }
    }

    private static class CreateReaderGroupEventBuilder
    implements ObjectBuilder<CreateReaderGroupEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long requestId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String rgName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long groupRefreshTimeMillis;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long automaticCheckpointIntervalMillis;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int maxOutstandingCheckpointRequest;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int retentionTypeOrdinal;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long generation;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID readerGroupId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, RGStreamCutRecord> startingStreamCuts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, RGStreamCutRecord> endingStreamCuts;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long createTimeStamp;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        CreateReaderGroupEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder rgName(String rgName) {
            this.rgName = rgName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder groupRefreshTimeMillis(long groupRefreshTimeMillis) {
            this.groupRefreshTimeMillis = groupRefreshTimeMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder automaticCheckpointIntervalMillis(long automaticCheckpointIntervalMillis) {
            this.automaticCheckpointIntervalMillis = automaticCheckpointIntervalMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder maxOutstandingCheckpointRequest(int maxOutstandingCheckpointRequest) {
            this.maxOutstandingCheckpointRequest = maxOutstandingCheckpointRequest;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder retentionTypeOrdinal(int retentionTypeOrdinal) {
            this.retentionTypeOrdinal = retentionTypeOrdinal;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder generation(long generation) {
            this.generation = generation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder readerGroupId(UUID readerGroupId) {
            this.readerGroupId = readerGroupId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder startingStreamCuts(Map<String, RGStreamCutRecord> startingStreamCuts) {
            this.startingStreamCuts = startingStreamCuts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder endingStreamCuts(Map<String, RGStreamCutRecord> endingStreamCuts) {
            this.endingStreamCuts = endingStreamCuts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEventBuilder createTimeStamp(long createTimeStamp) {
            this.createTimeStamp = createTimeStamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CreateReaderGroupEvent build() {
            return new CreateReaderGroupEvent(this.requestId, this.scope, this.rgName, this.groupRefreshTimeMillis, this.automaticCheckpointIntervalMillis, this.maxOutstandingCheckpointRequest, this.retentionTypeOrdinal, this.generation, this.readerGroupId, this.startingStreamCuts, this.endingStreamCuts, this.createTimeStamp);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CreateReaderGroupEvent.CreateReaderGroupEventBuilder(requestId=" + this.requestId + ", scope=" + this.scope + ", rgName=" + this.rgName + ", groupRefreshTimeMillis=" + this.groupRefreshTimeMillis + ", automaticCheckpointIntervalMillis=" + this.automaticCheckpointIntervalMillis + ", maxOutstandingCheckpointRequest=" + this.maxOutstandingCheckpointRequest + ", retentionTypeOrdinal=" + this.retentionTypeOrdinal + ", generation=" + this.generation + ", readerGroupId=" + this.readerGroupId + ", startingStreamCuts=" + this.startingStreamCuts + ", endingStreamCuts=" + this.endingStreamCuts + ", createTimeStamp=" + this.createTimeStamp + ")";
        }
    }
}

