/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.profiler.instrument.GuardInstrumentor;
import com.navercorp.pinpoint.profiler.plugin.TransformCallbackProvider;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Objects;

public class ClassFileTransformerDelegate
implements ClassFileTransformer {
    private final ProfilerConfig profilerConfig;
    private final InstrumentContext instrumentContext;
    private final TransformCallbackProvider transformCallbackProvider;

    public ClassFileTransformerDelegate(ProfilerConfig profilerConfig, InstrumentContext instrumentContext, TransformCallbackProvider transformCallbackProvider) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.instrumentContext = Objects.requireNonNull(instrumentContext, "instrumentContext");
        this.transformCallbackProvider = Objects.requireNonNull(transformCallbackProvider, "transformCallbackProvider");
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        Objects.requireNonNull(className, "className");
        InstrumentContext instrumentContext = this.instrumentContext;
        try (GuardInstrumentor guard = new GuardInstrumentor(this.profilerConfig, instrumentContext);){
            TransformCallback transformCallback = this.transformCallbackProvider.getTransformCallback(instrumentContext, loader);
            byte[] byArray = transformCallback.doInTransform((Instrumentor)guard, loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            return byArray;
        }
    }

    public String toString() {
        return "ClassFileTransformerDelegate{transformCallbackProvider=" + this.transformCallbackProvider + '}';
    }
}

