/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.DefaultFrameAttachment;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.annotation.Annotations;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Span
extends DefaultFrameAttachment
implements SpanType {
    private boolean timeRecording = true;
    private final TraceRoot traceRoot;
    private long startTime;
    private int elapsedTime;
    private int apiId;
    private short serviceType;
    private List<Annotation<?>> annotations;
    private List<SpanEvent> spanEventList;
    private String remoteAddr;
    private String parentApplicationName;
    private short parentApplicationType;
    private String acceptorHost;
    private IntStringValue exceptionInfo;

    public Span(TraceRoot traceRoot) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
    }

    public TraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(int elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public short getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(short serviceType) {
        this.serviceType = serviceType;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public List<Annotation<?>> getAnnotations() {
        return this.annotations;
    }

    public List<SpanEvent> getSpanEventList() {
        return this.spanEventList;
    }

    public void setSpanEventList(List<SpanEvent> spanEventList) {
        this.spanEventList = spanEventList;
    }

    public String getParentApplicationName() {
        return this.parentApplicationName;
    }

    public void setParentApplicationName(String parentApplicationName) {
        this.parentApplicationName = parentApplicationName;
    }

    public short getParentApplicationType() {
        return this.parentApplicationType;
    }

    public void setParentApplicationType(short parentApplicationType) {
        this.parentApplicationType = parentApplicationType;
    }

    public String getAcceptorHost() {
        return this.acceptorHost;
    }

    public void setAcceptorHost(String acceptorHost) {
        this.acceptorHost = acceptorHost;
    }

    public int getApiId() {
        return this.apiId;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public IntStringValue getExceptionInfo() {
        return this.exceptionInfo;
    }

    public void setExceptionInfo(IntStringValue exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public void markBeforeTime() {
        long spanStartTime = this.traceRoot.getTraceStartTime();
        this.setStartTime(spanStartTime);
    }

    public void setStartTime(long spanStartTime) {
        this.startTime = spanStartTime;
    }

    public void markAfterTime() {
        this.markAfterTime(System.currentTimeMillis());
    }

    public void markAfterTime(long currentTime) {
        int after = (int)(currentTime - this.getStartTime());
        this.setElapsedTime(after);
    }

    public void addAnnotation(Annotation<?> annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(annotation);
    }

    public void setExceptionInfo(int exceptionClassId, String exceptionMessage) {
        IntStringValue exceptionInfo = new IntStringValue(exceptionClassId, exceptionMessage);
        this.setExceptionInfo(exceptionInfo);
    }

    public boolean isTimeRecording() {
        return this.timeRecording;
    }

    public void setTimeRecording(boolean timeRecording) {
        this.timeRecording = timeRecording;
    }

    public void finish() {
        Shared shared = this.traceRoot.getShared();
        if (shared.getStatusCode() != 0) {
            Annotation<Integer> annotation = Annotations.of(AnnotationKey.HTTP_STATUS_CODE.getCode(), shared.getStatusCode());
            this.addAnnotation(annotation);
        }
    }

    public void clear() {
    }

    public String toString() {
        return "Span{timeRecording=" + this.timeRecording + ", traceRoot=" + this.traceRoot + ", startTime=" + this.startTime + ", elapsed=" + this.elapsedTime + ", serviceType=" + this.serviceType + ", remoteAddr='" + this.remoteAddr + '\'' + ", annotations=" + this.annotations + ", spanEventList=" + this.spanEventList + ", parentApplicationName='" + this.parentApplicationName + '\'' + ", parentApplicationType=" + this.parentApplicationType + ", acceptorHost='" + this.acceptorHost + '\'' + ", apiId=" + this.apiId + ", exceptionInfo=" + this.exceptionInfo + "} " + super.toString();
    }
}

