/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.redisson.api.executor.TaskListener;
import org.redisson.executor.SpringTasksInjector;
import org.redisson.executor.TasksInjector;
import org.springframework.beans.factory.BeanFactory;

public final class WorkerOptions {
    private int workers = 1;
    private ExecutorService executorService;
    private TasksInjector tasksInjector;
    private BeanFactory beanFactory;
    private long taskTimeout;
    private List<TaskListener> listeners = new ArrayList<TaskListener>();

    private WorkerOptions() {
    }

    public static WorkerOptions defaults() {
        return new WorkerOptions();
    }

    public int getWorkers() {
        return this.workers;
    }

    public WorkerOptions workers(int workers) {
        this.workers = workers;
        return this;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public WorkerOptions beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory != null) {
            this.tasksInjector = new SpringTasksInjector(beanFactory);
        }
        return this;
    }

    public TasksInjector getTasksInjector() {
        return this.tasksInjector;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public WorkerOptions executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public WorkerOptions taskTimeout(long timeout, TimeUnit unit) {
        this.taskTimeout = unit.toMillis(timeout);
        return this;
    }

    public long getTaskTimeout() {
        return this.taskTimeout;
    }

    public WorkerOptions addListener(TaskListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public List<TaskListener> getListeners() {
        return this.listeners;
    }
}

