/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.util;

import com.alibaba.otter.canal.connector.core.util.DateUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTypeUtil {
    private static Logger logger = LoggerFactory.getLogger(JdbcTypeUtil.class);

    public static Object getRSData(ResultSet rs, String columnName, int jdbcType) throws SQLException {
        if (jdbcType == -7 || jdbcType == 16) {
            return rs.getByte(columnName);
        }
        return rs.getObject(columnName);
    }

    public static Class<?> jdbcType2javaType(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 16: {
                return Byte.TYPE;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return byte[].class;
            }
            case 91: {
                return java.sql.Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        return String.class;
    }

    private static boolean isText(String columnType) {
        return "LONGTEXT".equalsIgnoreCase(columnType) || "MEDIUMTEXT".equalsIgnoreCase(columnType) || "TEXT".equalsIgnoreCase(columnType) || "TINYTEXT".equalsIgnoreCase(columnType);
    }

    public static Object typeConvert(String tableName, String columnName, String value, int sqlType, String mysqlType) {
        if (value == null || value.equals("") && !JdbcTypeUtil.isText(mysqlType) && sqlType != 1 && sqlType != 12 && sqlType != -1) {
            return null;
        }
        try {
            Object res;
            switch (sqlType) {
                case 4: {
                    res = Integer.parseInt(value);
                    break;
                }
                case 5: {
                    res = Short.parseShort(value);
                    break;
                }
                case -7: 
                case -6: {
                    res = Byte.parseByte(value);
                    break;
                }
                case -5: {
                    if (mysqlType != null && mysqlType.startsWith("bigint") && mysqlType.endsWith("unsigned")) {
                        res = new BigInteger(value);
                        break;
                    }
                    res = Long.parseLong(value);
                    break;
                }
                case 16: {
                    res = !"0".equals(value);
                    break;
                }
                case 6: 
                case 8: {
                    res = Double.parseDouble(value);
                    break;
                }
                case 7: {
                    res = Float.valueOf(Float.parseFloat(value));
                    break;
                }
                case 2: 
                case 3: {
                    res = new BigDecimal(value);
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    res = value.getBytes("ISO-8859-1");
                    break;
                }
                case 91: {
                    if (!value.startsWith("0000-00-00")) {
                        Date date = DateUtil.parseDate(value);
                        if (date != null) {
                            res = new java.sql.Date(date.getTime());
                            break;
                        }
                        res = null;
                        break;
                    }
                    res = null;
                    break;
                }
                case 92: {
                    Date date = DateUtil.parseDate(value);
                    if (date != null) {
                        res = new Time(date.getTime());
                        break;
                    }
                    res = null;
                    break;
                }
                case 93: {
                    if (!value.startsWith("0000-00-00")) {
                        Date date = DateUtil.parseDate(value);
                        if (date != null) {
                            res = new Timestamp(date.getTime());
                            break;
                        }
                        res = null;
                        break;
                    }
                    res = null;
                    break;
                }
                default: {
                    res = value;
                }
            }
            return res;
        }
        catch (Exception e) {
            logger.error("table: {} column: {}, failed convert type {} to {}", new Object[]{tableName, columnName, value, sqlType});
            return value;
        }
    }
}

