/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTopicConfig
extends ConsumerGroupTopicConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamTopicConfig.class);
    private final Map<String, Map<String, EventEmitter<CloudEvent>>> idcEmitterMap = new ConcurrentHashMap<String, Map<String, EventEmitter<CloudEvent>>>();
    private Map<String, List<EventEmitter<CloudEvent>>> idcEmitters = new ConcurrentHashMap<String, List<EventEmitter<CloudEvent>>>();
    private List<EventEmitter<CloudEvent>> totalEmitters = new ArrayList<EventEmitter<CloudEvent>>();

    public StreamTopicConfig(String consumerGroup, String topic, SubscriptionMode subscriptionMode) {
        super(consumerGroup, topic, subscriptionMode, GrpcType.STREAM);
    }

    private String concatKey(String ip, String pid) {
        return ip.concat(":").concat(pid);
    }

    @Override
    public synchronized void registerClient(ConsumerGroupClient client) {
        Objects.requireNonNull(client, "ConsumerGroupClient can not be null");
        if (client.getGrpcType() != this.grpcType) {
            log.warn("Invalid grpc type: {}, expecting grpc type: {}, can not register client {}", new Object[]{client.getGrpcType(), this.grpcType, client});
            return;
        }
        this.idcEmitterMap.computeIfAbsent(client.getIdc(), k -> new HashMap()).put(this.concatKey(client.getIp(), client.getPid()), client.getEventEmitter());
        this.idcEmitters = StreamTopicConfig.buildIdcEmitter(this.idcEmitterMap);
        this.totalEmitters = StreamTopicConfig.buildTotalEmitter(this.idcEmitters);
    }

    @Override
    public void deregisterClient(ConsumerGroupClient client) {
        String idc = client.getIdc();
        String clientIp = client.getIp();
        String clientPid = client.getPid();
        Map<String, EventEmitter<CloudEvent>> emitters = this.idcEmitterMap.get(idc);
        if (MapUtils.isEmpty(emitters)) {
            return;
        }
        emitters.remove(clientIp + ":" + clientPid);
        if (emitters.isEmpty()) {
            this.idcEmitterMap.remove(idc);
        }
        this.idcEmitters = StreamTopicConfig.buildIdcEmitter(this.idcEmitterMap);
        this.totalEmitters = StreamTopicConfig.buildTotalEmitter(this.idcEmitters);
    }

    @Override
    public int getSize() {
        return this.totalEmitters.size();
    }

    public String toString() {
        return "StreamConsumeTopicConfig={consumerGroup=" + this.consumerGroup + ",grpcType=" + this.grpcType + ",topic=" + this.topic + "}";
    }

    public Map<String, Map<String, EventEmitter<CloudEvent>>> getIdcEmitterMap() {
        return this.idcEmitterMap;
    }

    public Map<String, List<EventEmitter<CloudEvent>>> getIdcEmitters() {
        return this.idcEmitters;
    }

    public List<EventEmitter<CloudEvent>> getTotalEmitters() {
        return this.totalEmitters;
    }

    private static Map<String, List<EventEmitter<CloudEvent>>> buildIdcEmitter(Map<String, Map<String, EventEmitter<CloudEvent>>> idcEmitterMap) {
        HashMap<String, List<EventEmitter<CloudEvent>>> result = new HashMap<String, List<EventEmitter<CloudEvent>>>();
        idcEmitterMap.forEach((k, v) -> result.put((String)k, new LinkedList(v.values())));
        return result;
    }

    private static List<EventEmitter<CloudEvent>> buildTotalEmitter(Map<String, List<EventEmitter<CloudEvent>>> idcEmitters) {
        LinkedList<EventEmitter<CloudEvent>> emitterList = new LinkedList<EventEmitter<CloudEvent>>();
        idcEmitters.values().forEach(emitterList::addAll);
        return emitterList;
    }
}

