/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.rtm;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.slack.api.model.event.Event;
import com.slack.api.rtm.RTMEventHandler;
import com.slack.api.rtm.RTMEventsDispatcher;
import com.slack.api.rtm.RTMMessageHandler;
import com.slack.api.util.json.GsonFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMEventsDispatcherImpl
implements RTMEventsDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RTMEventsDispatcherImpl.class);
    private final ConcurrentMap<String, List<RTMEventHandler<?>>> eventTypeAndHandlers = new ConcurrentHashMap();

    @Override
    public void register(RTMEventHandler<? extends Event> handler) {
        String eventType = handler.getEventType();
        ArrayList<RTMEventHandler<? extends Event>> handlers = (ArrayList<RTMEventHandler<? extends Event>>)this.eventTypeAndHandlers.get(eventType);
        if (handlers == null) {
            handlers = new ArrayList<RTMEventHandler<? extends Event>>();
        }
        handlers.add(handler);
        this.eventTypeAndHandlers.put(eventType, handlers);
    }

    @Override
    public void deregister(RTMEventHandler<? extends Event> handler) {
        String eventType = handler.getEventType();
        ArrayList handlers = (ArrayList)this.eventTypeAndHandlers.get(eventType);
        if (handlers == null) {
            handlers = new ArrayList();
        }
        ArrayList<RTMEventHandler> newHandlers = new ArrayList<RTMEventHandler>();
        for (RTMEventHandler h : handlers) {
            if (h.equals(handler)) continue;
            newHandlers.add(h);
        }
        this.eventTypeAndHandlers.put(eventType, newHandlers);
    }

    @Override
    public void dispatch(String json) {
        JsonElement jsonMessage = JsonParser.parseString((String)json);
        if (!jsonMessage.isJsonObject()) {
            return;
        }
        String eventType = RTMEventsDispatcherImpl.detectEventType(jsonMessage.getAsJsonObject());
        String eventSubType = RTMEventsDispatcherImpl.detectEventSubType(jsonMessage.getAsJsonObject());
        if (eventType == null) {
            log.debug("Failed to detect event type from the given JSON data: {}", (Object)json);
            return;
        }
        List RTMEventHandlers = (List)this.eventTypeAndHandlers.get(eventType);
        if (RTMEventHandlers == null || RTMEventHandlers.size() == 0) {
            log.debug("No event handler registered for type: {}", (Object)eventType);
        } else {
            List rtmEventHandlers = RTMEventHandlers.stream().filter(e -> e.getEventSubType().equals(eventSubType)).collect(Collectors.toList());
            if (!rtmEventHandlers.isEmpty()) {
                Class clazz = ((RTMEventHandler)rtmEventHandlers.get(0)).getEventClass();
                for (RTMEventHandler handler : rtmEventHandlers) {
                    Event event = (Event)GsonFactory.createSnakeCase().fromJson(jsonMessage, clazz);
                    handler.acceptUntypedObject(event);
                }
            }
        }
    }

    @Override
    public RTMMessageHandler toMessageHandler() {
        final RTMEventsDispatcherImpl self = this;
        RTMMessageHandler messageHandler = new RTMMessageHandler(){

            @Override
            public void handle(String message) {
                self.dispatch(message);
            }
        };
        return messageHandler;
    }

    public static String detectEventType(JsonObject json) {
        JsonElement type = json.get("type");
        if (type == null || !type.isJsonPrimitive()) {
            return "";
        }
        return type.getAsString();
    }

    public static String detectEventSubType(JsonObject json) {
        JsonElement type = json.get("subtype");
        if (type == null || !type.isJsonPrimitive()) {
            return "";
        }
        return type.getAsString();
    }
}

