/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.utils;

import javax.faces.component.UIOutput;
import org.apache.empire.jsf2.utils.TagEncodingHelper;

public abstract class TagEncodingHelperFactory {
    private static TagEncodingHelperFactory factory = new DefaultTagEncodingHelperFactory();

    public static TagEncodingHelperFactory setFactory(TagEncodingHelperFactory newFactory) {
        TagEncodingHelperFactory previous = factory;
        factory = newFactory;
        return previous;
    }

    public static TagEncodingHelper create(UIOutput component, String cssStyleClass) {
        return factory.newInstance(component, cssStyleClass);
    }

    protected abstract TagEncodingHelper newInstance(UIOutput var1, String var2);

    private static class DefaultTagEncodingHelperFactory
    extends TagEncodingHelperFactory {
        private DefaultTagEncodingHelperFactory() {
        }

        @Override
        protected TagEncodingHelper newInstance(UIOutput component, String cssStyleClass) {
            return new TagEncodingHelper(component, cssStyleClass);
        }
    }

    public static interface TagEncodingHolder {
        public TagEncodingHelper getEncodingHelper();
    }
}

