/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.ListImagesInRecycleBinRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListImagesInRecycleBinRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ListImagesInRecycleBinRequest> {
    private SdkInternalList<String> imageIds;
    private String nextToken;
    private Integer maxResults;

    public List<String> getImageIds() {
        if (this.imageIds == null) {
            this.imageIds = new SdkInternalList();
        }
        return this.imageIds;
    }

    public void setImageIds(Collection<String> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
            return;
        }
        this.imageIds = new SdkInternalList(imageIds);
    }

    public ListImagesInRecycleBinRequest withImageIds(String ... imageIds) {
        if (this.imageIds == null) {
            this.setImageIds((Collection<String>)new SdkInternalList(imageIds.length));
        }
        for (String ele : imageIds) {
            this.imageIds.add((Object)ele);
        }
        return this;
    }

    public ListImagesInRecycleBinRequest withImageIds(Collection<String> imageIds) {
        this.setImageIds(imageIds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListImagesInRecycleBinRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListImagesInRecycleBinRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    @Override
    public Request<ListImagesInRecycleBinRequest> getDryRunRequest() {
        Request<ListImagesInRecycleBinRequest> request = new ListImagesInRecycleBinRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageIds() != null) {
            sb.append("ImageIds: ").append(this.getImageIds()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesInRecycleBinRequest)) {
            return false;
        }
        ListImagesInRecycleBinRequest other = (ListImagesInRecycleBinRequest)obj;
        if (other.getImageIds() == null ^ this.getImageIds() == null) {
            return false;
        }
        if (other.getImageIds() != null && !other.getImageIds().equals(this.getImageIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageIds() == null ? 0 : this.getImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public ListImagesInRecycleBinRequest clone() {
        return (ListImagesInRecycleBinRequest)super.clone();
    }
}

