/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kinesis;

import java.math.BigInteger;
import org.apache.druid.indexing.seekablestream.common.OrderedSequenceNumber;

public class KinesisSequenceNumber
extends OrderedSequenceNumber<String> {
    public static final String END_OF_SHARD_MARKER = "EOS";
    public static final String NO_END_SEQUENCE_NUMBER = "NO_END_SEQUENCE_NUMBER";
    public static final String EXPIRED_MARKER = "EXPIRED";
    public static final String UNREAD_TRIM_HORIZON = "UNREAD_TRIM_HORIZON";
    public static final String UNREAD_LATEST = "UNREAD_LATEST";
    private final boolean isMaxSequenceNumber;
    private final BigInteger intSequence;

    private KinesisSequenceNumber(String sequenceNumber, boolean isExclusive) {
        super((Object)sequenceNumber, isExclusive);
        if (!KinesisSequenceNumber.isValidAWSKinesisSequence(sequenceNumber)) {
            this.isMaxSequenceNumber = !this.isUnreadSequence(sequenceNumber);
            this.intSequence = null;
        } else {
            this.intSequence = new BigInteger(sequenceNumber);
            this.isMaxSequenceNumber = false;
        }
    }

    public static KinesisSequenceNumber of(String sequenceNumber) {
        return new KinesisSequenceNumber(sequenceNumber, false);
    }

    public static KinesisSequenceNumber of(String sequenceNumber, boolean isExclusive) {
        return new KinesisSequenceNumber(sequenceNumber, isExclusive);
    }

    public static boolean isValidAWSKinesisSequence(String sequenceNumber) {
        return !END_OF_SHARD_MARKER.equals(sequenceNumber) && !NO_END_SEQUENCE_NUMBER.equals(sequenceNumber) && !EXPIRED_MARKER.equals(sequenceNumber) && !UNREAD_TRIM_HORIZON.equals(sequenceNumber) && !UNREAD_LATEST.equals(sequenceNumber);
    }

    public int compareTo(OrderedSequenceNumber<String> o) {
        KinesisSequenceNumber num = (KinesisSequenceNumber)o;
        if (this.isUnread() && num.isUnread()) {
            return 0;
        }
        if (this.isUnread()) {
            return -1;
        }
        if (num.isUnread()) {
            return 1;
        }
        if (this.isMaxSequenceNumber && num.isMaxSequenceNumber) {
            return 0;
        }
        if (this.isMaxSequenceNumber) {
            return 1;
        }
        if (num.isMaxSequenceNumber) {
            return -1;
        }
        return this.intSequence.compareTo(new BigInteger((String)o.get()));
    }

    public boolean isAvailableWithEarliest(OrderedSequenceNumber<String> earliest) {
        if (this.isUnread()) {
            return true;
        }
        return super.isAvailableWithEarliest(earliest);
    }

    public boolean isMoreToReadBeforeReadingRecord(OrderedSequenceNumber<String> end, boolean isEndOffsetExclusive) {
        if (this.isUnreadSequence((String)end.get())) {
            return false;
        }
        return super.isMoreToReadBeforeReadingRecord(end, isEndOffsetExclusive);
    }

    public boolean isUnread() {
        return this.isUnreadSequence((String)this.get());
    }

    private boolean isUnreadSequence(String sequence) {
        return UNREAD_TRIM_HORIZON.equals(sequence) || UNREAD_LATEST.equals(sequence);
    }
}

