/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server;

import java.util.Arrays;
import java.util.List;
import org.apache.kerby.kerberos.kerb.common.Krb5Conf;
import org.apache.kerby.kerberos.kerb.server.KdcConfigKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;

public class KdcConfig
extends Krb5Conf {
    private static final String KDCDEFAULT = "kdcdefaults";

    public boolean enableDebug() {
        return this.getBoolean(KdcConfigKey.KRB_DEBUG, true, new String[]{KDCDEFAULT});
    }

    public String getKdcServiceName() {
        return this.getString(KdcConfigKey.KDC_SERVICE_NAME, true, new String[]{KDCDEFAULT});
    }

    public String getKdcHost() {
        return this.getString(KdcConfigKey.KDC_HOST, true, new String[]{KDCDEFAULT});
    }

    public int getKdcPort() {
        Integer kdcPort = this.getInt(KdcConfigKey.KDC_PORT, true, new String[]{KDCDEFAULT});
        if (kdcPort != null && kdcPort > 0) {
            return kdcPort;
        }
        return -1;
    }

    public int getKdcTcpPort() {
        Integer kdcTcpPort = this.getInt(KdcConfigKey.KDC_TCP_PORT, true, new String[]{KDCDEFAULT});
        if (kdcTcpPort != null && kdcTcpPort > 0) {
            return kdcTcpPort;
        }
        return this.getKdcPort();
    }

    public Boolean allowTcp() {
        return this.getBoolean(KdcConfigKey.KDC_ALLOW_TCP, true, new String[]{KDCDEFAULT}) != false || this.getInt(KdcConfigKey.KDC_TCP_PORT, true, new String[]{KDCDEFAULT}) != null || this.getInt(KdcConfigKey.KDC_PORT, false, new String[]{KDCDEFAULT}) != null;
    }

    public Boolean allowUdp() {
        return this.getBoolean(KdcConfigKey.KDC_ALLOW_UDP, true, new String[]{KDCDEFAULT}) != false || this.getInt(KdcConfigKey.KDC_UDP_PORT, true, new String[]{KDCDEFAULT}) != null || this.getInt(KdcConfigKey.KDC_PORT, false, new String[]{KDCDEFAULT}) != null;
    }

    public int getKdcUdpPort() {
        Integer kdcUdpPort = this.getInt(KdcConfigKey.KDC_UDP_PORT, true, new String[]{KDCDEFAULT});
        if (kdcUdpPort != null && kdcUdpPort > 0) {
            return kdcUdpPort;
        }
        return this.getKdcPort();
    }

    public String getKdcRealm() {
        return this.getString(KdcConfigKey.KDC_REALM, true, new String[]{KDCDEFAULT});
    }

    public String getKdcDomain() {
        return this.getString(KdcConfigKey.KDC_DOMAIN, true, new String[]{KDCDEFAULT});
    }

    public boolean isPreauthRequired() {
        return this.getBoolean(KdcConfigKey.PREAUTH_REQUIRED, true, new String[]{KDCDEFAULT});
    }

    public boolean isAllowTokenPreauth() {
        return this.getBoolean(KdcConfigKey.ALLOW_TOKEN_PREAUTH, true, new String[]{KDCDEFAULT});
    }

    public long getAllowableClockSkew() {
        return this.getLong(KdcConfigKey.ALLOWABLE_CLOCKSKEW, true, new String[]{KDCDEFAULT});
    }

    public boolean isEmptyAddressesAllowed() {
        return this.getBoolean(KdcConfigKey.EMPTY_ADDRESSES_ALLOWED, true, new String[]{KDCDEFAULT});
    }

    public boolean isForwardableAllowed() {
        return this.getBoolean(KdcConfigKey.FORWARDABLE_ALLOWED, true, new String[]{KDCDEFAULT});
    }

    public boolean isPostdatedAllowed() {
        return this.getBoolean(KdcConfigKey.POSTDATED_ALLOWED, true, new String[]{KDCDEFAULT});
    }

    public boolean isProxiableAllowed() {
        return this.getBoolean(KdcConfigKey.PROXIABLE_ALLOWED, true, new String[]{KDCDEFAULT});
    }

    public boolean isRenewableAllowed() {
        return this.getBoolean(KdcConfigKey.RENEWABLE_ALLOWED, true, new String[]{KDCDEFAULT});
    }

    public long getMaximumRenewableLifetime() {
        return this.getLong(KdcConfigKey.MAXIMUM_RENEWABLE_LIFETIME, true, new String[]{KDCDEFAULT});
    }

    public long getMaximumTicketLifetime() {
        return this.getLong(KdcConfigKey.MAXIMUM_TICKET_LIFETIME, true, new String[]{KDCDEFAULT});
    }

    public long getMinimumTicketLifetime() {
        return this.getLong(KdcConfigKey.MINIMUM_TICKET_LIFETIME, true, new String[]{KDCDEFAULT});
    }

    public List<EncryptionType> getEncryptionTypes() {
        return this.getEncTypes(KdcConfigKey.ENCRYPTION_TYPES, true, new String[]{KDCDEFAULT});
    }

    public boolean isPaEncTimestampRequired() {
        return this.getBoolean(KdcConfigKey.PA_ENC_TIMESTAMP_REQUIRED, true, new String[]{KDCDEFAULT});
    }

    public boolean isBodyChecksumVerified() {
        return this.getBoolean(KdcConfigKey.VERIFY_BODY_CHECKSUM, true, new String[]{KDCDEFAULT});
    }

    public boolean isRestrictAnonymousToTgt() {
        return this.getBoolean(KdcConfigKey.RESTRICT_ANONYMOUS_TO_TGT, true, new String[]{KDCDEFAULT});
    }

    public int getKdcMaxDgramReplySize() {
        return this.getInt(KdcConfigKey.KDC_MAX_DGRAM_REPLY_SIZE, true, new String[]{KDCDEFAULT});
    }

    public String getVerifyKeyConfig() {
        return this.getString(KdcConfigKey.TOKEN_VERIFY_KEYS, true, new String[]{KDCDEFAULT});
    }

    public String getDecryptionKeyConfig() {
        return this.getString(KdcConfigKey.TOKEN_DECRYPTION_KEYS, true, new String[]{KDCDEFAULT});
    }

    public List<String> getIssuers() {
        return Arrays.asList(this.getStringArray(KdcConfigKey.TOKEN_ISSUERS, true, new String[]{KDCDEFAULT}));
    }

    public List<String> getPkinitAnchors() {
        return Arrays.asList(this.getString(KdcConfigKey.PKINIT_ANCHORS, true, new String[]{KDCDEFAULT}));
    }

    public String getPkinitIdentity() {
        return this.getString(KdcConfigKey.PKINIT_IDENTITY, true, new String[]{KDCDEFAULT});
    }
}

