/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.segment.column.ColumnType;

public class SegmentSchemas {
    private final List<SegmentSchema> segmentSchemaList;

    @JsonCreator
    public SegmentSchemas(@JsonProperty(value="segmentSchemaList") List<SegmentSchema> segmentSchemaList) {
        this.segmentSchemaList = segmentSchemaList;
    }

    @JsonProperty
    public List<SegmentSchema> getSegmentSchemaList() {
        return this.segmentSchemaList;
    }

    public String toString() {
        return "SegmentSchemas{segmentSchemaList=" + String.valueOf(this.segmentSchemaList) + "}";
    }

    public static class SegmentSchema {
        private final String dataSource;
        private final String segmentId;
        private final boolean delta;
        private final Integer numRows;
        private final List<String> newColumns;
        private final List<String> updatedColumns;
        private final Map<String, ColumnType> columnTypeMap;

        @JsonCreator
        public SegmentSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segmentId") String segmentId, @JsonProperty(value="delta") boolean delta, @JsonProperty(value="numRows") Integer numRows, @JsonProperty(value="newColumns") List<String> newColumns, @JsonProperty(value="updatedColumns") List<String> updatedColumns, @JsonProperty(value="columnTypeMap") Map<String, ColumnType> columnTypeMap) {
            this.dataSource = dataSource;
            this.segmentId = segmentId;
            this.delta = delta;
            this.numRows = numRows;
            this.newColumns = newColumns;
            this.updatedColumns = updatedColumns;
            this.columnTypeMap = columnTypeMap;
        }

        @JsonProperty
        public String getDataSource() {
            return this.dataSource;
        }

        @JsonProperty
        public String getSegmentId() {
            return this.segmentId;
        }

        @JsonProperty
        public boolean isDelta() {
            return this.delta;
        }

        @JsonProperty
        public Integer getNumRows() {
            return this.numRows;
        }

        @JsonProperty
        public List<String> getNewColumns() {
            return this.newColumns;
        }

        @JsonProperty
        public List<String> getUpdatedColumns() {
            return this.updatedColumns;
        }

        @JsonProperty
        public Map<String, ColumnType> getColumnTypeMap() {
            return this.columnTypeMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentSchema that = (SegmentSchema)o;
            return this.delta == that.delta && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.segmentId, that.segmentId) && Objects.equals(this.numRows, that.numRows) && Objects.equals(this.newColumns, that.newColumns) && Objects.equals(this.updatedColumns, that.updatedColumns) && Objects.equals(this.columnTypeMap, that.columnTypeMap);
        }

        public int hashCode() {
            return Objects.hash(this.dataSource, this.segmentId, this.delta, this.numRows, this.newColumns, this.updatedColumns, this.columnTypeMap);
        }

        public String toString() {
            return "SegmentSchema{dataSource='" + this.dataSource + "', segmentId='" + this.segmentId + "', delta=" + this.delta + ", numRows=" + this.numRows + ", newColumns=" + String.valueOf(this.newColumns) + ", updatedColumns=" + String.valueOf(this.updatedColumns) + ", columnTypeMap=" + String.valueOf(this.columnTypeMap) + "}";
        }
    }
}

