/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto.enc;

import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;
import org.apache.kerby.kerberos.kerb.crypto.cksum.provider.Md5Provider;
import org.apache.kerby.kerberos.kerb.crypto.enc.AbstractEncTypeHandler;
import org.apache.kerby.kerberos.kerb.crypto.enc.provider.DesProvider;
import org.apache.kerby.kerberos.kerb.crypto.key.DesKeyMaker;
import org.apache.kerby.kerberos.kerb.crypto.util.Confounder;

abstract class DesCbcEnc
extends AbstractEncTypeHandler {
    DesCbcEnc(HashProvider hashProvider) {
        super(new DesProvider(), hashProvider, 16);
        this.keyMaker(new DesKeyMaker(this.encProvider()));
    }

    @Override
    public byte[] prf(byte[] key, byte[] seed) throws KrbException {
        Md5Provider md5Provider = new Md5Provider();
        md5Provider.hash(seed);
        byte[] output = md5Provider.output();
        this.encProvider().encrypt(key, output);
        return output;
    }

    @Override
    protected int paddingLength(int inputLen) {
        int payloadLen = this.confounderSize() + this.checksumSize() + inputLen;
        int padding = this.paddingSize();
        if (padding == 0 || payloadLen % padding == 0) {
            return 0;
        }
        return padding - payloadLen % padding;
    }

    @Override
    protected void encryptWith(byte[] workBuffer, int[] workLens, byte[] key, byte[] iv, int usage) throws KrbException {
        int confounderLen = workLens[0];
        int checksumLen = workLens[1];
        int dataLen = workLens[2];
        int paddingLen = workLens[3];
        byte[] confounder = Confounder.makeBytes(confounderLen);
        System.arraycopy(confounder, 0, workBuffer, 0, confounderLen);
        for (int i = confounderLen + checksumLen + dataLen; i < paddingLen; ++i) {
            workBuffer[i] = 0;
        }
        this.hashProvider().hash(workBuffer);
        byte[] cksum = this.hashProvider().output();
        System.arraycopy(cksum, 0, workBuffer, confounderLen, checksumLen);
        this.encProvider().encrypt(key, iv, workBuffer);
    }

    @Override
    protected byte[] decryptWith(byte[] workBuffer, int[] workLens, byte[] key, byte[] iv, int usage) throws KrbException {
        int confounderLen = workLens[0];
        int checksumLen = workLens[1];
        int dataLen = workLens[2];
        this.encProvider().decrypt(key, iv, workBuffer);
        byte[] checksum = new byte[checksumLen];
        for (int i = 0; i < checksumLen; ++i) {
            checksum[i] = workBuffer[confounderLen + i];
            workBuffer[confounderLen + i] = 0;
        }
        this.hashProvider().hash(workBuffer);
        byte[] newChecksum = this.hashProvider().output();
        if (!DesCbcEnc.checksumEqual(checksum, newChecksum)) {
            throw new KrbException(KrbErrorCode.KRB_AP_ERR_BAD_INTEGRITY);
        }
        byte[] data = new byte[dataLen];
        System.arraycopy(workBuffer, confounderLen + checksumLen, data, 0, dataLen);
        return data;
    }
}

