/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.builtin.MultiValueStringToArrayOperatorConversion;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidJoinQueryRel;
import org.apache.druid.sql.calcite.rel.DruidOuterQueryRel;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidRels;
import org.apache.druid.sql.calcite.rel.DruidUnnestRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidCorrelateUnnestRel
extends DruidRel<DruidCorrelateUnnestRel> {
    static final TableDataSource DUMMY_DATA_SOURCE = new TableDataSource("__correlate_unnest__"){

        public boolean isProcessable() {
            return false;
        }
    };
    private static final String BASE_UNNEST_OUTPUT_COLUMN = "unnest";
    private final Correlate correlateRel;
    private final RelNode left;
    private final RelNode right;
    private final PartialDruidQuery partialQuery;

    private DruidCorrelateUnnestRel(RelOptCluster cluster, RelTraitSet traitSet, Correlate correlateRel, PartialDruidQuery partialQuery, PlannerContext plannerContext) {
        super(cluster, traitSet, plannerContext);
        this.correlateRel = correlateRel;
        this.partialQuery = partialQuery;
        this.left = correlateRel.getLeft();
        this.right = correlateRel.getRight();
    }

    public static DruidCorrelateUnnestRel create(Correlate correlateRel, PlannerContext plannerContext) {
        return new DruidCorrelateUnnestRel(correlateRel.getCluster(), correlateRel.getTraitSet(), correlateRel, PartialDruidQuery.create((RelNode)correlateRel), plannerContext);
    }

    @Override
    @Nullable
    public PartialDruidQuery getPartialDruidQuery() {
        return this.partialQuery;
    }

    @Override
    public DruidCorrelateUnnestRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidCorrelateUnnestRel(this.getCluster(), newQueryBuilder.getTraitSet(this.getConvention(), this.getPlannerContext()), this.correlateRel, newQueryBuilder, this.getPlannerContext());
    }

    @Override
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        Object leftDataSource1;
        DruidRel newLeftDruidRel;
        DimFilter unnestFilterOnDataSource;
        DruidRel leftDruidRel = (DruidRel)this.left;
        PartialDruidQuery leftPartialQuery = leftDruidRel.getPartialDruidQuery();
        DruidQuery leftQuery = (DruidQuery)Preconditions.checkNotNull((Object)leftDruidRel.toDruidQuery(false), (Object)"leftQuery");
        DruidUnnestRel unnestDatasourceRel = (DruidUnnestRel)this.right;
        Filter unnestFilter = unnestDatasourceRel.getUnnestFilter();
        if (this.right.getRowType().getFieldNames().size() != 1) {
            throw new CannotBuildQueryException("Cannot perform correlated join + UNNEST with more than one column");
        }
        RexNode rexNodeToUnnest = DruidCorrelateUnnestRel.getRexNodeToUnnest(this.correlateRel, unnestDatasourceRel);
        RowSignature leftDataSourceSignature = unnestDatasourceRel.getInputRexNode().getKind() == SqlKind.OTHER_FUNCTION ? leftQuery.getOutputRowSignature() : (leftDruidRel instanceof DruidOuterQueryRel ? DruidRels.dataSourceSignature((DruidRel)((Object)leftDruidRel.getInputs().get(0))) : DruidRels.dataSourceSignature(leftDruidRel));
        DruidExpression expressionToUnnest = Expressions.toDruidExpression(this.getPlannerContext(), leftDataSourceSignature, rexNodeToUnnest);
        if (expressionToUnnest == null) {
            throw new CannotBuildQueryException((RelNode)unnestDatasourceRel, unnestDatasourceRel.getInputRexNode());
        }
        RowSignature correlateRowSignature = DruidCorrelateUnnestRel.getCorrelateRowSignature(this.correlateRel, leftQuery);
        if (unnestFilter != null) {
            RowSignature filterRowSignature = RowSignatures.fromRelDataType((List<String>)ImmutableList.of((Object)correlateRowSignature.getColumnName(correlateRowSignature.size() - 1)), unnestFilter.getInput().getRowType());
            unnestFilterOnDataSource = Filtration.create(DruidQuery.getDimFilter(this.getPlannerContext(), filterRowSignature, null, unnestFilter)).optimizeFilterOnly(filterRowSignature).getDimFilter();
        } else {
            unnestFilterOnDataSource = null;
        }
        if (unnestDatasourceRel.getInputRexNode().getKind() == SqlKind.FIELD_ACCESS && expressionToUnnest.isSimpleExtraction()) {
            LogicalProject newProject;
            PartialDruidQuery leftPartialQueryToBeUpdated = leftDruidRel instanceof DruidOuterQueryRel ? ((DruidRel)((Object)leftDruidRel.getInputs().get(0))).getPartialDruidQuery() : leftPartialQuery;
            Project leftProject = leftPartialQueryToBeUpdated.getSelectProject();
            String dimensionToUpdate = expressionToUnnest.getDirectColumn();
            if (leftProject == null) {
                newProject = null;
            } else {
                ProjectUpdateShuttle pus = new ProjectUpdateShuttle(DruidCorrelateUnnestRel.unwrapMvToArray(rexNodeToUnnest), leftProject, dimensionToUpdate);
                List out = pus.visitList(leftProject.getProjects());
                RelDataType structType = RexUtil.createStructType((RelDataTypeFactory)this.getCluster().getTypeFactory(), (List)out, pus.getTypeNames());
                newProject = LogicalProject.create((RelNode)leftProject.getInput(), (List)leftProject.getHints(), (List)out, (RelDataType)structType);
            }
            DruidRel leftFinalRel = leftDruidRel instanceof DruidOuterQueryRel ? (DruidRel)((Object)leftDruidRel.getInputs().get(0)) : leftDruidRel;
            PartialDruidQuery pq = PartialDruidQuery.create(leftPartialQueryToBeUpdated.getScan()).withWhereFilter(leftPartialQueryToBeUpdated.getWhereFilter()).withSelectProject((Project)newProject).withSort(leftPartialQueryToBeUpdated.getSort());
            if (leftPartialQuery.stage() == PartialDruidQuery.Stage.SORT_PROJECT) {
                Project sortProject = leftPartialQueryToBeUpdated.getSortProject();
                ProjectUpdateShuttle pus = new ProjectUpdateShuttle(DruidCorrelateUnnestRel.unwrapMvToArray(rexNodeToUnnest), sortProject, dimensionToUpdate);
                List out = pus.visitList(sortProject.getProjects());
                RelDataType structType = RexUtil.createStructType((RelDataTypeFactory)this.getCluster().getTypeFactory(), (List)out, pus.getTypeNames());
                LogicalProject newSortProject = LogicalProject.create((RelNode)sortProject.getInput(), (List)sortProject.getHints(), (List)out, (RelDataType)structType);
                newLeftDruidRel = leftFinalRel.withPartialQuery(pq.withSortProject((Project)newSortProject));
            } else {
                newLeftDruidRel = leftFinalRel.withPartialQuery(pq);
            }
        } else {
            newLeftDruidRel = leftDruidRel;
        }
        DruidQuery updatedLeftQuery = (DruidQuery)Preconditions.checkNotNull((Object)newLeftDruidRel.toDruidQuery(false), (Object)"leftQuery");
        if (newLeftDruidRel.getPartialDruidQuery().stage().compareTo(PartialDruidQuery.Stage.SELECT_PROJECT) <= 0) {
            Filter whereFilter = newLeftDruidRel.getPartialDruidQuery().getWhereFilter();
            RowSignature leftSignature = DruidRels.dataSourceSignature(newLeftDruidRel);
            if (whereFilter == null) {
                leftDataSource1 = DruidCorrelateUnnestRel.computeLeftRequiresSubquery(newLeftDruidRel) ? new QueryDataSource(updatedLeftQuery.getQuery()) : updatedLeftQuery.getDataSource();
            } else {
                DimFilter dimFilter = Filtration.create(DruidQuery.getDimFilter(this.getPlannerContext(), leftSignature, null, whereFilter)).optimizeFilterOnly(leftSignature).getDimFilter();
                leftDataSource1 = FilteredDataSource.create((DataSource)updatedLeftQuery.getDataSource(), (DimFilter)dimFilter);
            }
        } else {
            leftDataSource1 = new QueryDataSource(updatedLeftQuery.getQuery());
        }
        QueryDataSource leftDataSource = leftDataSource1;
        return this.partialQuery.build((DataSource)UnnestDataSource.create((DataSource)leftDataSource, (VirtualColumn)expressionToUnnest.toVirtualColumn(correlateRowSignature.getColumnName(correlateRowSignature.size() - 1), Calcites.getColumnTypeForRelDataType(rexNodeToUnnest.getType()), this.getPlannerContext().getExpressionParser()), (DimFilter)unnestFilterOnDataSource), correlateRowSignature, this.getPlannerContext(), this.getCluster().getRexBuilder(), finalizeAggregations, true);
    }

    protected RelDataType deriveRowType() {
        return this.partialQuery.getRowType();
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.partialQuery.build((DataSource)DUMMY_DATA_SOURCE, RowSignatures.fromRelDataType(this.correlateRel.getRowType().getFieldNames(), this.correlateRel.getRowType()), this.getPlannerContext(), this.getCluster().getRexBuilder(), false, false);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        DruidQuery druidQuery = this.toDruidQueryForExplaining();
        try {
            queryString = this.getPlannerContext().getJsonMapper().writeValueAsString(druidQuery.getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this.correlateRel.explainTerms(pw).item("query", (Object)queryString).item("signature", (Object)druidQuery.getOutputRowSignature());
    }

    @Override
    public DruidCorrelateUnnestRel asDruidConvention() {
        return new DruidCorrelateUnnestRel(this.getCluster(), this.getTraitSet().replace((RelTrait)DruidConvention.instance()), this.correlateRel.copy(this.correlateRel.getTraitSet(), this.correlateRel.getInputs().stream().map(input -> RelOptRule.convert((RelNode)input, (RelTrait)DruidConvention.instance())).collect(Collectors.toList())), this.partialQuery, this.getPlannerContext());
    }

    public List<RelNode> getInputs() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidCorrelateUnnestRel(this.getCluster(), traitSet, this.correlateRel.copy(this.correlateRel.getTraitSet(), inputs), this.getPartialDruidQuery(), this.getPlannerContext());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double cost = this.partialQuery.estimateCost();
        if (DruidCorrelateUnnestRel.computeLeftRequiresSubquery(DruidJoinQueryRel.getSomeDruidChild(this.left))) {
            cost += 100000.0;
        }
        return planner.getCostFactory().makeCost(cost, 0.0, 0.0);
    }

    @Override
    public Set<String> getDataSourceNames() {
        HashSet<String> retVal = new HashSet<String>();
        retVal.addAll(((DruidRel)this.left).getDataSourceNames());
        retVal.addAll(((DruidRel)this.right).getDataSourceNames());
        return retVal;
    }

    public static boolean computeLeftRequiresSubquery(DruidRel<?> left) {
        return left == null || left.getPartialDruidQuery().stage() != PartialDruidQuery.Stage.SCAN;
    }

    private static boolean isMvToArrayOfInputRef(RexNode expr) {
        return expr.isA(SqlKind.OTHER_FUNCTION) && ((RexCall)expr).op.equals((Object)MultiValueStringToArrayOperatorConversion.SQL_FUNCTION) && ((RexNode)((RexCall)expr).getOperands().get(0)).isA(SqlKind.INPUT_REF);
    }

    private static RexNode unwrapMvToArray(RexNode expr) {
        if (DruidCorrelateUnnestRel.isMvToArrayOfInputRef(expr)) {
            return (RexNode)((RexCall)expr).getOperands().get(0);
        }
        return expr;
    }

    private static RowSignature getCorrelateRowSignature(Correlate correlate, DruidQuery leftQuery) {
        RelDataType unnestedType = ((RelDataTypeField)correlate.getRowType().getFieldList().get(correlate.getRowType().getFieldCount() - 1)).getType();
        return (RowSignature)DruidJoinQueryRel.computeJoinRowSignature((RowSignature)leftQuery.getOutputRowSignature(), (RowSignature)RowSignature.builder().add((String)BASE_UNNEST_OUTPUT_COLUMN, (ColumnType)Calcites.getColumnTypeForRelDataType((RelDataType)unnestedType)).build(), DruidJoinQueryRel.findExistingJoinPrefixes((DataSource[])new DataSource[]{leftQuery.getDataSource()})).rhs;
    }

    private static RexNode getRexNodeToUnnest(Correlate correlate, DruidUnnestRel unnestDatasourceRel) {
        RexNode unnestRexNode;
        PartialDruidQuery partialDruidQuery = correlate.getLeft() instanceof DruidOuterQueryRel ? ((DruidRel)((Object)correlate.getLeft().getInputs().get(0))).getPartialDruidQuery() : (correlate.getLeft() instanceof DruidQueryRel ? ((DruidQueryRel)correlate.getLeft()).getPartialDruidQuery() : ((DruidRel)correlate.getLeft()).getPartialDruidQuery());
        Project leftProject = partialDruidQuery.getSelectProject();
        Project sortProject = partialDruidQuery.getSortProject();
        if (leftProject == null && sortProject == null) {
            unnestRexNode = unnestDatasourceRel.getInputRexNode();
        } else if (unnestDatasourceRel.getInputRexNode().getKind() == SqlKind.FIELD_ACCESS) {
            int indexRef = ((RexFieldAccess)unnestDatasourceRel.getInputRexNode()).getField().getIndex();
            unnestRexNode = leftProject != null ? (RexNode)leftProject.getProjects().get(indexRef) : (RexNode)sortProject.getProjects().get(indexRef);
        } else {
            unnestRexNode = unnestDatasourceRel.getInputRexNode();
        }
        RexNode rexNodeToUnnest = new CorrelatedFieldAccessToInputRef(correlate.getCorrelationId()).apply(unnestRexNode);
        return DruidCorrelateUnnestRel.unwrapMvToArray(rexNodeToUnnest);
    }

    private static class ProjectUpdateShuttle
    extends RexShuttle {
        private RexNode nodeToBeAdded;
        private List<String> types;
        private Project project;
        private String dim;

        public ProjectUpdateShuttle(RexNode node, Project project, String dimension) {
            this.nodeToBeAdded = node;
            this.project = project;
            this.types = new ArrayList<String>(project.getProjects().size());
            this.dim = dimension;
        }

        public List<String> getTypeNames() {
            return this.types;
        }

        public void visitList(Iterable<? extends RexNode> exprs, List<RexNode> out) {
            List typeNames = this.project.getRowType().getFieldNames();
            int i = 0;
            for (RexNode rexNode : exprs) {
                RexNode updatedExpr = DruidCorrelateUnnestRel.unwrapMvToArray(rexNode);
                if (!Objects.equals(updatedExpr, this.nodeToBeAdded)) {
                    out.add(updatedExpr);
                    this.types.add((String)typeNames.get(i));
                }
                ++i;
            }
            out.add(this.nodeToBeAdded);
            this.types.add(this.dim);
        }
    }

    public static class CorrelatedFieldAccessToInputRef
    extends RexShuttle {
        private final CorrelationId correlationId;

        public CorrelatedFieldAccessToInputRef(CorrelationId correlationId) {
            this.correlationId = correlationId;
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (fieldAccess.getReferenceExpr() instanceof RexCorrelVariable) {
                RexCorrelVariable encounteredCorrelationId = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                if (encounteredCorrelationId.id.equals((Object)this.correlationId)) {
                    return new RexInputRef(fieldAccess.getField().getIndex(), fieldAccess.getType());
                }
            }
            return super.visitFieldAccess(fieldAccess);
        }
    }
}

