/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class TrimOperatorConversion
implements SqlOperatorConversion {
    @Nullable
    public static DruidExpression makeTrimExpression(SqlTrimFunction.Flag trimStyle, DruidExpression stringExpression, DruidExpression charsExpression, ColumnType druidType) {
        String functionName;
        switch (trimStyle) {
            case LEADING: {
                functionName = "ltrim";
                break;
            }
            case TRAILING: {
                functionName = "rtrim";
                break;
            }
            case BOTH: {
                functionName = "trim";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return DruidExpression.ofFunctionCall(druidType, functionName, (List<DruidExpression>)ImmutableList.of((Object)stringExpression, (Object)charsExpression));
    }

    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.TRIM;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        RexLiteral flag = (RexLiteral)call.getOperands().get(0);
        SqlTrimFunction.Flag trimStyle = (SqlTrimFunction.Flag)flag.getValue();
        DruidExpression charsExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(1));
        DruidExpression stringExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)call.getOperands().get(2));
        if (charsExpression == null || stringExpression == null) {
            return null;
        }
        return TrimOperatorConversion.makeTrimExpression(trimStyle, stringExpression, charsExpression, Calcites.getColumnTypeForRelDataType(rexNode.getType()));
    }
}

