/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.extraction.CascadeExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;

public class ExtractionFns {
    public static Granularity toQueryGranularity(ExtractionFn extractionFn) {
        TimeFormatExtractionFn fn;
        if (extractionFn instanceof TimeFormatExtractionFn && (fn = (TimeFormatExtractionFn)extractionFn).getFormat() == null && fn.getTimeZone() == null && fn.getLocale() == null && fn.isAsMillis()) {
            return fn.getGranularity();
        }
        return null;
    }

    public static ExtractionFn fromQueryGranularity(Granularity queryGranularity) {
        if (queryGranularity == null) {
            return null;
        }
        return new TimeFormatExtractionFn(null, null, null, queryGranularity, true);
    }

    public static ExtractionFn cascade(ExtractionFn f, ExtractionFn g) {
        if (f == null) {
            return g;
        }
        if (g == null) {
            return f;
        }
        ArrayList<ExtractionFn> extractionFns = new ArrayList<ExtractionFn>();
        if (f instanceof CascadeExtractionFn) {
            extractionFns.addAll(Arrays.asList(((CascadeExtractionFn)f).getExtractionFns()));
        } else {
            extractionFns.add(f);
        }
        if (g instanceof CascadeExtractionFn) {
            extractionFns.addAll(Arrays.asList(((CascadeExtractionFn)g).getExtractionFns()));
        } else {
            extractionFns.add(g);
        }
        return new CascadeExtractionFn(extractionFns.toArray(new ExtractionFn[0]));
    }
}

