/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.DoubleWrappingDimensionSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;

public class DoubleDimensionIndexer
implements DimensionIndexer<Double, Double, Double> {
    public static final Comparator<Double> DOUBLE_COMPARATOR = Comparators.naturalNullsFirst();
    private final String dimensionName;
    private volatile boolean hasNulls = false;

    public DoubleDimensionIndexer(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public EncodedKeyComponent<Double> processRowValsToUnsortedEncodedKeyComponent(@Nullable Object dimValues, boolean reportParseExceptions) {
        Double d = DimensionHandlerUtils.convertObjectToDouble(dimValues, reportParseExceptions, this.dimensionName);
        if (d == null) {
            this.hasNulls = true;
        }
        return new EncodedKeyComponent<Double>(d, 8L);
    }

    @Override
    public void setSparseIndexed() {
        this.hasNulls = true;
    }

    @Override
    public Double getUnsortedEncodedValueFromSorted(Double sortedIntermediateValue) {
        return sortedIntermediateValue;
    }

    @Override
    public CloseableIndexed<Double> getSortedIndexedValues() {
        throw new UnsupportedOperationException("Numeric columns do not support value dictionaries.");
    }

    @Override
    public Double getMinValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public Double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int getCardinality() {
        return -1;
    }

    @Override
    public ColumnCapabilities getColumnCapabilities() {
        ColumnCapabilitiesImpl builder = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.DOUBLE);
        if (this.hasNulls) {
            builder.setHasNulls(this.hasNulls);
        }
        return builder;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec spec, IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        return new DoubleWrappingDimensionSelector(this.makeColumnValueSelector(currEntry, desc), spec.getExtractionFn());
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final IncrementalIndexRowHolder currEntry, IncrementalIndex.DimensionDesc desc) {
        final int dimIndex = desc.getIndex();
        class IndexerDoubleColumnSelector
        implements DoubleColumnSelector {
            IndexerDoubleColumnSelector() {
            }

            @Override
            public boolean isNull() {
                Object[] dims = currEntry.get().getDims();
                return DoubleDimensionIndexer.this.hasNulls && (dimIndex >= dims.length || dims[dimIndex] == null);
            }

            @Override
            public double getDouble() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    assert (!this.isNull());
                    return 0.0;
                }
                return (Double)dims[dimIndex];
            }

            @Override
            @Nullable
            public Double getObject() {
                Object[] dims = currEntry.get().getDims();
                if (dimIndex >= dims.length || dims[dimIndex] == null) {
                    return null;
                }
                return (Double)dims[dimIndex];
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            }
        }
        return new IndexerDoubleColumnSelector();
    }

    @Override
    public int compareUnsortedEncodedKeyComponents(@Nullable Double lhs, @Nullable Double rhs) {
        return DOUBLE_COMPARATOR.compare(lhs, rhs);
    }

    @Override
    public boolean checkUnsortedEncodedKeyComponentsEqual(@Nullable Double lhs, @Nullable Double rhs) {
        return Objects.equals(lhs, rhs);
    }

    @Override
    public int getUnsortedEncodedKeyComponentHashCode(@Nullable Double key) {
        return DimensionHandlerUtils.nullToZero(key).hashCode();
    }

    @Override
    public Object convertUnsortedEncodedKeyComponentToActualList(Double key) {
        return key;
    }

    @Override
    public ColumnValueSelector convertUnsortedValuesToSorted(ColumnValueSelector selectorWithUnsortedValues) {
        return selectorWithUnsortedValues;
    }

    @Override
    public void fillBitmapsFromUnsortedEncodedKeyComponent(Double key, int rowNum, MutableBitmap[] bitmapIndexes, BitmapFactory factory) {
        throw new UnsupportedOperationException("Numeric columns do not support bitmaps.");
    }
}

