/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.query.QueryResourceId;

@LazySingleton
public class GroupByStatsProvider {
    private final Map<QueryResourceId, PerQueryStats> perQueryStats = new ConcurrentHashMap<QueryResourceId, PerQueryStats>();
    private final AggregateStats aggregateStatsContainer = new AggregateStats();

    public PerQueryStats getPerQueryStatsContainer(QueryResourceId resourceId) {
        if (resourceId == null) {
            return null;
        }
        return this.perQueryStats.computeIfAbsent(resourceId, value -> new PerQueryStats());
    }

    public synchronized void closeQuery(QueryResourceId resourceId) {
        if (resourceId == null || !this.perQueryStats.containsKey(resourceId)) {
            return;
        }
        PerQueryStats container = this.perQueryStats.remove(resourceId);
        this.aggregateStatsContainer.addQueryStats(container);
    }

    public synchronized AggregateStats getStatsSince() {
        return this.aggregateStatsContainer.reset();
    }

    public static class AggregateStats {
        private long mergeBufferQueries = 0L;
        private long mergeBufferAcquisitionTimeNs = 0L;
        private long spilledQueries = 0L;
        private long spilledBytes = 0L;
        private long mergeDictionarySize = 0L;

        public AggregateStats() {
        }

        public AggregateStats(long mergeBufferQueries, long mergeBufferAcquisitionTimeNs, long spilledQueries, long spilledBytes, long mergeDictionarySize) {
            this.mergeBufferQueries = mergeBufferQueries;
            this.mergeBufferAcquisitionTimeNs = mergeBufferAcquisitionTimeNs;
            this.spilledQueries = spilledQueries;
            this.spilledBytes = spilledBytes;
            this.mergeDictionarySize = mergeDictionarySize;
        }

        public long getMergeBufferQueries() {
            return this.mergeBufferQueries;
        }

        public long getMergeBufferAcquisitionTimeNs() {
            return this.mergeBufferAcquisitionTimeNs;
        }

        public long getSpilledQueries() {
            return this.spilledQueries;
        }

        public long getSpilledBytes() {
            return this.spilledBytes;
        }

        public long getMergeDictionarySize() {
            return this.mergeDictionarySize;
        }

        public void addQueryStats(PerQueryStats perQueryStats) {
            if (perQueryStats.getMergeBufferAcquisitionTimeNs() > 0L) {
                ++this.mergeBufferQueries;
                this.mergeBufferAcquisitionTimeNs += perQueryStats.getMergeBufferAcquisitionTimeNs();
            }
            if (perQueryStats.getSpilledBytes() > 0L) {
                ++this.spilledQueries;
                this.spilledBytes += perQueryStats.getSpilledBytes();
            }
            this.mergeDictionarySize += perQueryStats.getMergeDictionarySize();
        }

        public AggregateStats reset() {
            AggregateStats aggregateStats = new AggregateStats(this.mergeBufferQueries, this.mergeBufferAcquisitionTimeNs, this.spilledQueries, this.spilledBytes, this.mergeDictionarySize);
            this.mergeBufferQueries = 0L;
            this.mergeBufferAcquisitionTimeNs = 0L;
            this.spilledQueries = 0L;
            this.spilledBytes = 0L;
            this.mergeDictionarySize = 0L;
            return aggregateStats;
        }
    }

    public static class PerQueryStats {
        private final AtomicLong mergeBufferAcquisitionTimeNs = new AtomicLong(0L);
        private final AtomicLong spilledBytes = new AtomicLong(0L);
        private final AtomicLong mergeDictionarySize = new AtomicLong(0L);

        public void mergeBufferAcquisitionTime(long delay) {
            this.mergeBufferAcquisitionTimeNs.addAndGet(delay);
        }

        public void spilledBytes(long bytes) {
            this.spilledBytes.addAndGet(bytes);
        }

        public void dictionarySize(long size) {
            this.mergeDictionarySize.addAndGet(size);
        }

        public long getMergeBufferAcquisitionTimeNs() {
            return this.mergeBufferAcquisitionTimeNs.get();
        }

        public long getSpilledBytes() {
            return this.spilledBytes.get();
        }

        public long getMergeDictionarySize() {
            return this.mergeDictionarySize.get();
        }
    }
}

