/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TimeBoundaryInspector;

public class GroupByQueryRunnerFactory
implements QueryRunnerFactory<ResultRow, GroupByQuery> {
    private final GroupingEngine groupingEngine;
    private final GroupByQueryQueryToolChest toolChest;
    private final NonBlockingPool<ByteBuffer> processingBufferPool;

    @Inject
    public GroupByQueryRunnerFactory(GroupingEngine groupingEngine, GroupByQueryQueryToolChest toolChest, @Global NonBlockingPool<ByteBuffer> processingBufferPool) {
        this.groupingEngine = groupingEngine;
        this.toolChest = toolChest;
        this.processingBufferPool = processingBufferPool;
    }

    @Override
    public QueryRunner<ResultRow> createRunner(Segment segment) {
        return new GroupByQueryRunner(segment, this.groupingEngine, this.processingBufferPool);
    }

    @Override
    public QueryRunner<ResultRow> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<ResultRow>> queryRunners) {
        return (queryPlus, responseContext) -> {
            QueryRunner<ResultRow> rowQueryRunner = this.groupingEngine.mergeRunners(queryProcessingPool, queryRunners);
            return rowQueryRunner.run(queryPlus, responseContext);
        };
    }

    @Override
    public QueryToolChest<ResultRow, GroupByQuery> getToolchest() {
        return this.toolChest;
    }

    @VisibleForTesting
    public GroupingEngine getGroupingEngine() {
        return this.groupingEngine;
    }

    private static class GroupByQueryRunner
    implements QueryRunner<ResultRow> {
        private final CursorFactory cursorFactory;
        @Nullable
        private final TimeBoundaryInspector timeBoundaryInspector;
        private final GroupingEngine groupingEngine;
        private final NonBlockingPool<ByteBuffer> processingBufferPool;

        public GroupByQueryRunner(Segment segment, GroupingEngine groupingEngine, NonBlockingPool<ByteBuffer> processingBufferPool) {
            this.cursorFactory = Objects.requireNonNull(segment.as(CursorFactory.class));
            this.timeBoundaryInspector = segment.as(TimeBoundaryInspector.class);
            this.groupingEngine = groupingEngine;
            this.processingBufferPool = processingBufferPool;
        }

        @Override
        public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
            Query<ResultRow> query = queryPlus.getQuery();
            if (!(query instanceof GroupByQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", query.getClass(), GroupByQuery.class);
            }
            return this.groupingEngine.process((GroupByQuery)query, this.cursorFactory, this.timeBoundaryInspector, this.processingBufferPool, (GroupByQueryMetrics)queryPlus.getQueryMetrics());
        }
    }
}

