/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.metrics.NoopTaskHolder;
import org.apache.druid.java.util.metrics.TaskHolder;

public class ServiceEmitter
implements Emitter {
    private final Emitter emitter;
    private final String service;
    private final ImmutableMap<String, String> otherServiceDimensions;
    private final String host;
    private final TaskHolder taskHolder;
    private ImmutableMap<String, String> serviceDimensions;

    public ServiceEmitter(String service, String host, Emitter emitter) {
        this(service, host, emitter, (ImmutableMap<String, String>)ImmutableMap.of(), new NoopTaskHolder());
    }

    public ServiceEmitter(String service, String host, Emitter emitter, ImmutableMap<String, String> otherServiceDimensions, TaskHolder taskHolder) {
        this.service = (String)Preconditions.checkNotNull((Object)service, (Object)"service should be non-null");
        this.host = (String)Preconditions.checkNotNull((Object)host, (Object)"host should be non-null");
        this.otherServiceDimensions = otherServiceDimensions;
        this.emitter = emitter;
        this.taskHolder = taskHolder;
    }

    @Override
    @LifecycleStart
    public void start() {
        this.serviceDimensions = ImmutableMap.builder().put((Object)"service", (Object)this.service).put((Object)"host", (Object)this.host).putAll(this.otherServiceDimensions).putAll(this.taskHolder.getMetricDimensions()).build();
        this.emitter.start();
    }

    @Override
    public void emit(Event event) {
        this.emitter.emit(event);
    }

    public <E extends Event> void emit(ServiceEventBuilder<E> builder) {
        this.emit((Event)builder.build(this.serviceDimensions));
    }

    @Override
    public void flush() throws IOException {
        this.emitter.flush();
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        this.emitter.close();
    }

    public String toString() {
        return "ServiceEmitter{serviceDimensions=" + String.valueOf(this.serviceDimensions) + ", emitter=" + String.valueOf(this.emitter) + "}";
    }
}

