/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class MergeIterator<T>
implements Iterator<T> {
    private static final int PRIORITY_QUEUE_INITIAL_CAPACITY = 16;
    private final PriorityQueue<PeekingIterator<T>> pQueue = new PriorityQueue(16, (lhs, rhs) -> comparator.compare(lhs.peek(), rhs.peek()));
    private PeekingIterator<T> currentIterator = null;

    public MergeIterator(Iterable<? extends Iterator<? extends T>> sortedIterators, Comparator<? super T> comparator) {
        for (Iterator<T> iterator : sortedIterators) {
            PeekingIterator iter = Iterators.peekingIterator(iterator);
            if (iter == null || !iter.hasNext()) continue;
            this.pQueue.add(iter);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.pQueue.isEmpty() || this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentIterator != null) {
            if (this.currentIterator.hasNext()) {
                this.pQueue.add(this.currentIterator);
            }
            this.currentIterator = null;
        }
        PeekingIterator retIt = (PeekingIterator)this.pQueue.remove();
        Object retVal = retIt.next();
        this.currentIterator = retIt;
        return (T)retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

