/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.cast;

import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.write.cast.TypeCastSelectors;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.RowIdSupplier;

public class ObjectToArrayColumnValueSelector
implements ColumnValueSelector<Object[]> {
    private final ColumnValueSelector<?> selector;
    @Nullable
    private final ExpressionType desiredType;
    @Nullable
    private final RowIdSupplier rowIdSupplier;

    public ObjectToArrayColumnValueSelector(ColumnValueSelector<?> selector, ExpressionType desiredType, @Nullable RowIdSupplier rowIdSupplier) {
        this.selector = selector;
        this.desiredType = desiredType;
        this.rowIdSupplier = rowIdSupplier;
        if (!desiredType.isArray() || desiredType.getElementType() == null) {
            throw DruidException.defensive("Expected array with nonnull element type, got[%s]", desiredType);
        }
    }

    @Override
    public double getDouble() {
        throw DruidException.defensive("Unexpected call to getDouble on array selector", new Object[0]);
    }

    @Override
    public float getFloat() {
        throw DruidException.defensive("Unexpected call to getFloat on array selector", new Object[0]);
    }

    @Override
    public long getLong() {
        throw DruidException.defensive("Unexpected call to getLong on array selector", new Object[0]);
    }

    @Override
    public boolean isNull() {
        throw DruidException.defensive("Unexpected call to isNull on array selector", new Object[0]);
    }

    @Override
    @Nullable
    public Object[] getObject() {
        return (Object[])TypeCastSelectors.bestEffortCoerce(this.selector.getObject(), this.desiredType);
    }

    @Override
    public Class<Object[]> classOfObject() {
        return Object[].class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("rowIdSupplier", this.rowIdSupplier);
    }
}

