/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.FirewallRuleInner;
import com.azure.resourcemanager.sql.implementation.SqlFirewallRuleImpl;
import com.azure.resourcemanager.sql.implementation.SqlFirewallRulesAsExternalChildResourcesImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SqlFirewallRule;
import com.azure.resourcemanager.sql.models.SqlFirewallRuleOperations;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlFirewallRuleOperationsImpl
implements SqlFirewallRuleOperations,
SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition {
    private SqlServerManager sqlServerManager;
    private SqlServer sqlServer;
    private SqlFirewallRulesAsExternalChildResourcesImpl sqlFirewallRules;

    SqlFirewallRuleOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
        this.sqlFirewallRules = new SqlFirewallRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlFirewallRule");
    }

    SqlFirewallRuleOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.sqlFirewallRules = new SqlFirewallRulesAsExternalChildResourcesImpl(sqlServerManager, "SqlFirewallRule");
    }

    @Override
    public SqlFirewallRule getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        FirewallRuleInner inner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().get(resourceGroupName, sqlServerName, name);
        return inner != null ? new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlFirewallRule> getBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().getAsync(resourceGroupName, sqlServerName, name).map(inner -> new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), (FirewallRuleInner)((Object)inner), this.sqlServerManager));
    }

    @Override
    public SqlFirewallRule getBySqlServer(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        FirewallRuleInner inner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return inner != null ? new SqlFirewallRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlFirewallRule> getBySqlServerAsync(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map(inner -> new SqlFirewallRuleImpl(name, (SqlServerImpl)sqlServer, (FirewallRuleInner)((Object)inner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public SqlFirewallRule get(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer, name);
    }

    @Override
    public Mono<SqlFirewallRule> getAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer, name);
    }

    @Override
    public SqlFirewallRule getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Mono<SqlFirewallRule> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Mono<Void> deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().deleteAsync(resourceGroupName, sqlServerName, name);
    }

    @Override
    public void deleteById(String id) {
        Objects.requireNonNull(id);
        this.deleteBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.deleteBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)), ResourceUtils.nameFromResourceId((String)id));
    }

    @Override
    public void delete(String name) {
        if (this.sqlServer != null) {
            this.deleteBySqlServer(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
        }
    }

    @Override
    public Mono<Void> deleteAsync(String name) {
        if (this.sqlServer == null) {
            return null;
        }
        return this.deleteBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), name);
    }

    @Override
    public List<SqlFirewallRule> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlFirewallRuleImpl> firewallRuleSet = new ArrayList<SqlFirewallRuleImpl>();
        PagedIterable<FirewallRuleInner> firewallRuleInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().listByServer(resourceGroupName, sqlServerName);
        for (FirewallRuleInner inner : firewallRuleInners) {
            firewallRuleSet.add(new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(firewallRuleSet);
    }

    @Override
    public PagedFlux<SqlFirewallRule> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().listByServerAsync(resourceGroupName, sqlServerName), inner -> new SqlFirewallRuleImpl(resourceGroupName, sqlServerName, inner.name(), (FirewallRuleInner)((Object)inner), this.sqlServerManager));
    }

    @Override
    public List<SqlFirewallRule> listBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ArrayList<SqlFirewallRuleImpl> firewallRuleSet = new ArrayList<SqlFirewallRuleImpl>();
        for (FirewallRuleInner inner : ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getFirewallRules().listByServer(sqlServer.resourceGroupName(), sqlServer.name())) {
            firewallRuleSet.add(new SqlFirewallRuleImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager())));
        }
        return Collections.unmodifiableList(firewallRuleSet);
    }

    @Override
    public PagedFlux<SqlFirewallRule> listBySqlServerAsync(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return PagedConverter.mapPage(((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getFirewallRules().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()), inner -> new SqlFirewallRuleImpl(inner.name(), (SqlServerImpl)sqlServer, (FirewallRuleInner)((Object)inner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public List<SqlFirewallRule> list() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServer(this.sqlServer);
    }

    @Override
    public PagedFlux<SqlFirewallRule> listAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServerAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name());
    }

    @Override
    public SqlFirewallRuleImpl define(String name) {
        SqlFirewallRuleImpl result = this.sqlFirewallRules.defineIndependentFirewallRule(name);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }
}

