/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.FailoverGroupInner;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.FailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.PartnerInfo;
import com.azure.resourcemanager.sql.models.ReadOnlyEndpointFailoverPolicy;
import com.azure.resourcemanager.sql.models.ReadWriteEndpointFailoverPolicy;
import com.azure.resourcemanager.sql.models.SqlFailoverGroup;
import com.azure.resourcemanager.sql.models.SqlFailoverGroupOperations;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlFailoverGroupImpl
extends ExternalChildResourceImpl<SqlFailoverGroup, FailoverGroupInner, SqlServerImpl, SqlServer>
implements SqlFailoverGroup,
SqlFailoverGroup.Update,
SqlFailoverGroupOperations.SqlFailoverGroupOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    protected String sqlServerLocation;

    SqlFailoverGroupImpl(String name, SqlServerImpl parent, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        this.sqlServerLocation = parent.regionName();
    }

    SqlFailoverGroupImpl(String resourceGroupName, String sqlServerName, String sqlServerLocation, String name, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
    }

    SqlFailoverGroupImpl(String name, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
                this.sqlServerLocation = innerObject.location();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected String sqlServerLocation() {
        return this.sqlServerLocation;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((FailoverGroupInner)((Object)this.innerModel())).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((FailoverGroupInner)((Object)this.innerModel())).id());
    }

    @Override
    public ReadWriteEndpointFailoverPolicy readWriteEndpointPolicy() {
        return ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint() != null ? ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint().failoverPolicy() : null;
    }

    @Override
    public int readWriteEndpointDataLossGracePeriodMinutes() {
        return ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint() != null && ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint().failoverWithDataLossGracePeriodMinutes() != null ? ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint().failoverWithDataLossGracePeriodMinutes() : 0;
    }

    @Override
    public ReadOnlyEndpointFailoverPolicy readOnlyEndpointPolicy() {
        return ((FailoverGroupInner)((Object)this.innerModel())).readOnlyEndpoint() != null ? ((FailoverGroupInner)((Object)this.innerModel())).readOnlyEndpoint().failoverPolicy() : null;
    }

    @Override
    public FailoverGroupReplicationRole replicationRole() {
        return ((FailoverGroupInner)((Object)this.innerModel())).replicationRole();
    }

    @Override
    public String replicationState() {
        return ((FailoverGroupInner)((Object)this.innerModel())).replicationState();
    }

    @Override
    public List<PartnerInfo> partnerServers() {
        return Collections.unmodifiableList(((FailoverGroupInner)((Object)this.innerModel())).partnerServers() != null ? ((FailoverGroupInner)((Object)this.innerModel())).partnerServers() : new ArrayList());
    }

    @Override
    public List<String> databases() {
        return Collections.unmodifiableList(((FailoverGroupInner)((Object)this.innerModel())).databases() != null ? ((FailoverGroupInner)((Object)this.innerModel())).databases() : new ArrayList());
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlFailoverGroupImpl withExistingSqlServer(String resourceGroupName, String sqlServerName, String sqlServerLocation) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        this.sqlServerLocation = sqlServer.regionName();
        return this;
    }

    public SqlFailoverGroupImpl update() {
        super.prepareUpdate();
        return this;
    }

    public Mono<SqlFailoverGroup> createResourceAsync() {
        SqlFailoverGroupImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.name(), (FailoverGroupInner)((Object)self.innerModel())).map(failoverGroupInner -> {
            self.setInner(failoverGroupInner);
            return self;
        });
    }

    public Mono<SqlFailoverGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    protected Mono<FailoverGroupInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public String type() {
        return ((FailoverGroupInner)((Object)this.innerModel())).type();
    }

    public String regionName() {
        return ((FailoverGroupInner)((Object)this.innerModel())).location();
    }

    public Region region() {
        return Region.fromName((String)((FailoverGroupInner)((Object)this.innerModel())).location());
    }

    public Map<String, String> tags() {
        return ((FailoverGroupInner)((Object)this.innerModel())).tags();
    }

    public SqlFailoverGroupImpl withTags(Map<String, String> tags) {
        ((FailoverGroupInner)((Object)this.innerModel())).withTags(new HashMap<String, String>(tags));
        return this;
    }

    public SqlFailoverGroupImpl withTag(String key, String value) {
        if (((FailoverGroupInner)((Object)this.innerModel())).tags() == null) {
            ((FailoverGroupInner)((Object)this.innerModel())).withTags(new HashMap<String, String>());
        }
        ((FailoverGroupInner)((Object)this.innerModel())).tags().put(key, value);
        return this;
    }

    public SqlFailoverGroupImpl withoutTag(String key) {
        if (((FailoverGroupInner)((Object)this.innerModel())).tags() != null) {
            ((FailoverGroupInner)((Object)this.innerModel())).tags().remove(key);
        }
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withAutomaticReadWriteEndpointPolicyAndDataLossGracePeriod(int gracePeriodInMinutes) {
        if (((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.innerModel())).withReadWriteEndpoint(new FailoverGroupReadWriteEndpoint());
        }
        ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint().withFailoverPolicy(ReadWriteEndpointFailoverPolicy.AUTOMATIC);
        ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint().withFailoverWithDataLossGracePeriodMinutes(gracePeriodInMinutes);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withManualReadWriteEndpointPolicy() {
        if (((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.innerModel())).withReadWriteEndpoint(new FailoverGroupReadWriteEndpoint());
        }
        ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint().withFailoverPolicy(ReadWriteEndpointFailoverPolicy.MANUAL);
        ((FailoverGroupInner)((Object)this.innerModel())).readWriteEndpoint().withFailoverWithDataLossGracePeriodMinutes(null);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withReadOnlyEndpointPolicyEnabled() {
        if (((FailoverGroupInner)((Object)this.innerModel())).readOnlyEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.innerModel())).withReadOnlyEndpoint(new FailoverGroupReadOnlyEndpoint());
        }
        ((FailoverGroupInner)((Object)this.innerModel())).readOnlyEndpoint().withFailoverPolicy(ReadOnlyEndpointFailoverPolicy.ENABLED);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withReadOnlyEndpointPolicyDisabled() {
        if (((FailoverGroupInner)((Object)this.innerModel())).readOnlyEndpoint() == null) {
            ((FailoverGroupInner)((Object)this.innerModel())).withReadOnlyEndpoint(new FailoverGroupReadOnlyEndpoint());
        }
        ((FailoverGroupInner)((Object)this.innerModel())).readOnlyEndpoint().withFailoverPolicy(ReadOnlyEndpointFailoverPolicy.DISABLED);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withPartnerServerId(String id) {
        ((FailoverGroupInner)((Object)this.innerModel())).withPartnerServers(new ArrayList<PartnerInfo>());
        ((FailoverGroupInner)((Object)this.innerModel())).partnerServers().add(new PartnerInfo().withId(id));
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withDatabaseId(String id) {
        if (((FailoverGroupInner)((Object)this.innerModel())).databases() == null) {
            ((FailoverGroupInner)((Object)this.innerModel())).withDatabases(new ArrayList<String>());
        }
        ((FailoverGroupInner)((Object)this.innerModel())).databases().add(id);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withNewDatabaseId(String id) {
        return this.withDatabaseId(id);
    }

    @Override
    public SqlFailoverGroupImpl withDatabaseIds(String ... ids) {
        ((FailoverGroupInner)((Object)this.innerModel())).withDatabases(new ArrayList<String>());
        for (String id : ids) {
            ((FailoverGroupInner)((Object)this.innerModel())).databases().add(id);
        }
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withoutDatabaseId(String id) {
        if (((FailoverGroupInner)((Object)this.innerModel())).databases() != null) {
            ((FailoverGroupInner)((Object)this.innerModel())).databases().remove(id);
        }
        return this;
    }
}

