/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Set;
import java.util.regex.Pattern;

public class TaskConstants {
    public static final String YARN_APPLICATION_REGEX = "application_\\d+_\\d+";
    public static final String FLINK_APPLICATION_REGEX = "JobID \\w+";
    public static final String DATASOURCE_PASSWORD_REGEX = "(?<=((?i)password((\" : \")|(\":\")|(\\\\\":\\\\\")|(=')))).*?(?=((\")|(\\\\\")|(')))";
    public static final int EXIT_CODE_KILL = 137;
    public static final int EXIT_CODE_HARD_KILL = 143;
    public static final String PID = "pid";
    public static final String QUESTION = "?";
    public static final String COMMA = ",";
    public static final String HYPHEN = "-";
    public static final String SLASH = "/";
    public static final String COLON = ":";
    public static final String SPACE = " ";
    public static final String SINGLE_SLASH = "/";
    public static final String DOUBLE_SLASH = "//";
    public static final String SINGLE_QUOTES = "'";
    public static final String DOUBLE_QUOTES = "\"";
    public static final String SEMICOLON = ";";
    public static final String EQUAL_SIGN = "=";
    public static final String UNDERLINE = "_";
    public static final int SLEEP_TIME_MILLIS = 1000;
    public static final int EXIT_CODE_FAILURE = -1;
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int RUNNING_CODE = 1;
    public static final String SH = "sh";
    public static final int DEFAULT_LOG_FLUSH_INTERVAL = 1000;
    public static final String PSTREE = "pstree";
    public static final String RWXR_XR_X = "rwxr-xr-x";
    public static final String PARAMETER_FORMAT_TIME = "yyyyMMddHHmmss";
    public static final String PARAMETER_SHECDULE_TIME = "schedule.time";
    public static final String PARAMETER_DATETIME = "system.datetime";
    public static final String PARAMETER_CURRENT_DATE = "system.biz.curdate";
    public static final String PARAMETER_BUSINESS_DATE = "system.biz.date";
    public static final String PARAMETER_TASK_EXECUTE_PATH = "system.task.execute.path";
    public static final String PARAMETER_TASK_INSTANCE_ID = "system.task.instance.id";
    public static final String PARAMETER_TASK_DEFINITION_CODE = "system.task.definition.code";
    public static final String PARAMETER_TASK_DEFINITION_NAME = "system.task.definition.name";
    public static final String PARAMETER_WORKFLOW_INSTANCE_ID = "system.workflow.instance.id";
    public static final String PARAMETER_WORKFLOW_DEFINITION_CODE = "system.workflow.definition.code";
    public static final String PARAMETER_WORKFLOW_DEFINITION_NAME = "system.workflow.definition.name";
    public static final String PARAMETER_PROJECT_CODE = "system.project.code";
    public static final String PARAMETER_PROJECT_NAME = "system.project.name";
    public static final String MONTH_BEGIN = "month_begin";
    public static final String ADD_MONTHS = "add_months";
    public static final String MONTH_END = "month_end";
    public static final String WEEK_BEGIN = "week_begin";
    public static final String WEEK_END = "week_end";
    public static final String THIS_DAY = "this_day";
    public static final String LAST_DAY = "last_day";
    public static final String MONTH_FIRST_DAY = "month_first_day";
    public static final String MONTH_LAST_DAY = "month_last_day";
    public static final String WEEK_FIRST_DAY = "week_first_day";
    public static final String WEEK_LAST_DAY = "week_last_day";
    public static final String YEAR_WEEK = "year_week";
    public static final String TIMESTAMP = "timestamp";
    public static final char SUBTRACT_CHAR = '-';
    public static final char ADD_CHAR = '+';
    public static final char MULTIPLY_CHAR = '*';
    public static final char DIVISION_CHAR = '/';
    public static final char LEFT_BRACE_CHAR = '(';
    public static final char RIGHT_BRACE_CHAR = ')';
    public static final String ADD_STRING = "+";
    public static final String MULTIPLY_STRING = "*";
    public static final String DIVISION_STRING = "/";
    public static final String LEFT_BRACE_STRING = "(";
    public static final char P = 'P';
    public static final char N = 'N';
    public static final String SUBTRACT_STRING = "-";
    public static final String LOCAL_PARAMS_LIST = "localParamsList";
    public static final String TASK_TYPE = "taskType";
    public static final String QUEUE = "queue";
    public static final int DEFAULT_DISPLAY_ROWS = 10;
    public static final String JAR = "jar";
    public static final String HADOOP = "hadoop";
    public static final String D = "-D";
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String JAVA_SECURITY_KRB5_CONF_PATH = "java.security.krb5.conf.path";
    public static final String HADOOP_SECURITY_AUTHENTICATION_STARTUP_STATE = "hadoop.security.authentication.startup.state";
    public static final String TASK_TYPE_DATA_QUALITY = "DATA_QUALITY";
    public static final Set<String> TASK_TYPE_SET_K8S = Sets.newHashSet((Object[])new String[]{"K8S", "KUBEFLOW"});
    public static final String AZURE_CLIENT_ID = "resource.azure.client.id";
    public static final String AZURE_CLIENT_SECRET = "resource.azure.client.secret";
    public static final String AZURE_ACCESS_SUB_ID = "resource.azure.subId";
    public static final String AZURE_SECRET_TENANT_ID = "resource.azure.tenant.id";
    public static final String QUERY_INTERVAL = "resource.query.interval";
    public static final String API_VERSION = "batch/v1";
    public static final String RESTART_POLICY = "Never";
    public static final String MEMORY = "memory";
    public static final String CPU = "cpu";
    public static final String LAYER_LABEL = "k8s.cn/layer";
    public static final String LAYER_LABEL_VALUE = "batch";
    public static final String NAME_LABEL = "k8s.cn/name";
    public static final String TASK_INSTANCE_ID = "taskInstanceId";
    public static final String MI = "Mi";
    public static final int JOB_TTL_SECONDS = 300;
    public static final int LOG_LINES = 500;
    public static final String NAMESPACE_NAME = "name";
    public static final String CLUSTER = "cluster";
    public static final String UNIQUE_LABEL_NAME = "dolphinscheduler-label";
    public static final String CONDA_PATH = "conda.path";
    public static final Duration DEFAULT_LOOP_STATUS_INTERVAL = Duration.ofSeconds(5L);
    public static final String GROUP_NAME1 = "paramName1";
    public static final String GROUP_NAME2 = "paramName2";
    public static final String SQL_PARAMS_REGEX = String.format("['\"]\\$\\{(?<%s>.*?)}['\"]|\\$\\{(?<%s>.*?)}", "paramName1", "paramName2");
    public static final Pattern SQL_PARAMS_PATTERN = Pattern.compile(SQL_PARAMS_REGEX);
    public static final String LOGIN_USER_KEY_TAB_USERNAME = "login.user.keytab.username";
    public static final String LOGIN_USER_KEY_TAB_PATH = "login.user.keytab.path";
    public static final String APPID_COLLECT = "appId.collect";
    public static final String DEFAULT_COLLECT_WAY = "log";
    public static final String WORKFLOW_INSTANCE_ID_MDC_KEY = "workflowInstanceId";
    public static final String TASK_INSTANCE_ID_MDC_KEY = "taskInstanceId";
    public static final String STAR = "*";
    public static final String SENSITIVE_DATA_MASK = "******";

    private TaskConstants() {
        throw new IllegalStateException("Utility class");
    }
}

