/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.object.heap;

import com.terracottatech.frs.object.ValueSortedMap;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class HeapValueSortedMap<K, V extends Comparable<V>>
implements ValueSortedMap<K, V> {
    private final Map<K, Node<K, V>> map = new HashMap<K, Node<K, V>>();
    private final PriorityQueue<Node<K, V>> sorted = new PriorityQueue();

    @Override
    public K firstKey() {
        Node<K, V> first = this.sorted.peek();
        if (first == null) {
            return null;
        }
        return (K)((Node)first).key;
    }

    @Override
    public V firstValue() {
        Node<K, V> first = this.sorted.peek();
        if (first == null) {
            return null;
        }
        return (V)((Node)first).value;
    }

    @Override
    public void put(K key, V value) {
        Node<K, V> node = new Node<K, V>(key, value);
        this.sorted.remove(this.map.put(key, node));
        this.sorted.add(node);
    }

    @Override
    public void remove(K key) {
        this.sorted.remove(this.map.remove(key));
    }

    public void clear() {
        this.sorted.clear();
        this.map.clear();
    }

    @Override
    public V get(K key) {
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        return (V)((Node)node).value;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    static class Node<K, V extends Comparable<V>>
    implements Comparable<Node<K, V>> {
        private final K key;
        private final V value;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(Node<K, V> t) {
            return this.value.compareTo(t.value);
        }
    }
}

