/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.systest.jaxrs.security;

import java.util.HashMap;
import java.util.Map;

import jakarta.annotation.Resource;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;

@Path("/bookstorestorage/")
public class SecureBookStore extends AbstractSecureBookStore implements SecureBookInterface {
    private Map<Long, Book> books = new HashMap<>();
    private SecureBookInterface subresource;
    private UriInfo uriInfo;

    public SecureBookStore() {
        Book book = new Book();
        book.setId(123L);
        book.setName("CXF in Action");
        books.put(book.getId(), book);
    }

    @Context
    public void setUriInfo(UriInfo ui) {
        uriInfo = ui;
    }

    @Resource
    public void setBookStore(SecureBookInterface sb) {
        subresource = sb;
    }

    public Book getThatBook(Long id) {
        return books.get(id);
    }

    public Book getThatBook(Long id, String s) {
        if (s == null) {
            throw new RuntimeException();
        }
        return books.get(id);
    }

    public Book getThatBook() throws BookNotFoundFault {
        if (!uriInfo.getBaseUri().getScheme().startsWith("http")) {
            throw new WebApplicationException(500);
        }
        if ((securityContext.isUserInRole("ROLE_ADMIN")
            || securityContext.isUserInRole("ROLE_BOOK_OWNER"))
            && !securityContext.isUserInRole("ROLE_BAZ")) {
            return books.get(123L);
        }
        throw new WebApplicationException(403);
    }

    public SecureBookInterface getBookSubResource() throws BookNotFoundFault {
        return subresource;
    }

    public Book getDefaultBook() throws BookNotFoundFault {
        return books.get(123L);
    }

    @Path("/securebook")
    public SecureBook getSecureBook() throws BookNotFoundFault {
        return new SecureBook("CXF in Action", 123L);
    }
}
