/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import org.apache.commons.exec.AbstractExecTest;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class Exec60Test
extends AbstractExecTest {
    private final Executor exec = DefaultExecutor.builder().get();
    private final File pingScript = this.resolveTestScript("ping");

    Exec60Test() {
    }

    @Disabled(value="The test is fragile and might fail out of the blue")
    @Test
    void testExec60() throws Exception {
        boolean start = false;
        boolean seconds = true;
        boolean offsetMultiplier = true;
        int maxRetries = 180;
        int processTerminatedCounter = 0;
        int watchdogKilledProcessCounter = 0;
        CommandLine cmdLine = new CommandLine(this.pingScript);
        cmdLine.addArgument(Integer.toString(2));
        long startTime = System.currentTimeMillis();
        for (int offset = 0; offset <= 180; ++offset) {
            ExecuteWatchdog watchdog = new ExecuteWatchdog((long)(1000 + offset * 1));
            this.exec.setWatchdog(watchdog);
            try {
                this.exec.execute(cmdLine);
                if (++processTerminatedCounter <= 5) continue;
                break;
            }
            catch (ExecuteException ex) {
                Assertions.assertTrue((boolean)watchdog.killedProcess(), (String)"Watchdog killed the process");
                ++watchdogKilledProcessCounter;
            }
        }
        long avg = (System.currentTimeMillis() - startTime) / (long)(watchdogKilledProcessCounter + processTerminatedCounter);
        System.out.println("Processes terminated: " + processTerminatedCounter + " killed: " + watchdogKilledProcessCounter + " Multiplier: " + 1 + " MaxRetries: " + 180 + " Elapsed (avg ms): " + avg);
        Assertions.assertTrue((processTerminatedCounter > 0 ? 1 : 0) != 0, (String)"Not a single process terminated on its own");
        Assertions.assertTrue((watchdogKilledProcessCounter > 0 ? 1 : 0) != 0, (String)"Not a single process was killed by the watch dog");
    }
}

