/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.commit;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.celeborn.client.commit.AbstractPartitionCompletenessValidator;
import org.apache.celeborn.common.CommitMetadata;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.com.google.common.base.Preconditions;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u001b\t!3k[3x\u0011\u0006tG\r\\5oO^KG\u000f[8vi6\u000b\u0007OU1oO\u00164\u0016\r\\5eCR|'O\u0003\u0002\u0004\t\u000511m\\7nSRT!!\u0002\u0004\u0002\r\rd\u0017.\u001a8u\u0015\t9\u0001\"\u0001\u0005dK2,'m\u001c:o\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011a%\u00112tiJ\f7\r\u001e)beRLG/[8o\u0007>l\u0007\u000f\\3uK:,7o\u001d,bY&$\u0017\r^8s\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0010\u0001!9q\u0003\u0001b\u0001\n\u0013A\u0012a\u0007;pi\u0006d7+\u001e2QCJ$\u0018\u000e^5p]N\u0004&o\\2fgN,G-F\u0001\u001a!\u0011Q\u0012eI\u0015\u000e\u0003mQ!\u0001H\u000f\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u001f?\u0005!Q\u000f^5m\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000e\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0002J]R\u0004BAK\u0016$[5\tQ$\u0003\u0002-;\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0007\u0003\u0019\u0019w.\\7p]&\u0011!g\f\u0002\u000f\u0007>lW.\u001b;NKR\fG-\u0019;b\u0011\u0019!\u0004\u0001)A\u00053\u0005aBo\u001c;bYN+(\rU1si&$\u0018n\u001c8t!J|7-Z:tK\u0012\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u001da\u0006\u0014H/\u001b;j_:$vnU;c!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\u0005A\u0004\u0003\u0002\u000e\"G\rBaA\u000f\u0001!\u0002\u0013A\u0014!\b9beRLG/[8o)>\u001cVO\u0019)beRLG/[8o\u0007>,h\u000e\u001e\u0011\t\u000fq\u0002!\u0019!C\u0005{\u0005y2-\u001e:sK:$8i\\7nSRlU\r^1eCR\fgi\u001c:SK\u0012,8-\u001a:\u0016\u0003y\u0002BAG\u0011$[!1\u0001\t\u0001Q\u0001\ny\n\u0001eY;se\u0016tGoQ8n[&$X*\u001a;bI\u0006$\u0018MR8s%\u0016$WoY3sA!)!\t\u0001C!\u0007\u0006\u0019\u0002O]8dKN\u001c8+\u001e2QCJ$\u0018\u000e^5p]R1A)U*V/f\u0003B\u0001J#H\u0015&\u0011a)\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0011B\u0015BA%&\u0005\u001d\u0011un\u001c7fC:\u0004\"a\u0013(\u000f\u0005\u0011b\u0015BA'&\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055+\u0003\"\u0002*B\u0001\u0004\u0019\u0013a\u00039beRLG/[8o\u0013\u0012DQ\u0001V!A\u0002\r\nQb\u001d;beRl\u0015\r]%oI\u0016D\b\"\u0002,B\u0001\u0004\u0019\u0013aC3oI6\u000b\u0007/\u00138eKbDQ\u0001W!A\u00025\nA#Y2uk\u0006d7i\\7nSRlU\r^1eCR\f\u0007\"\u0002.B\u0001\u0004\u0019\u0013\u0001G3ya\u0016\u001cG/\u001a3U_R\fG.T1qa\u0016\u00148i\\;oi\")A\f\u0001C\u0005;\u0006!R\u000f\u001d3bi\u0016\u001cu.\\7ji6+G/\u00193bi\u0006$2AX1c!\t!s,\u0003\u0002aK\t!QK\\5u\u0011\u0015\u00116\f1\u0001$\u0011\u0015A6\f1\u0001.\u0011\u0015!\u0007\u0001\"\u0003f\u0003\u0019:W\r\u001e+pi\u0006dg*^7cKJ|emU;c!\u0006\u0014H/\u001b;j_:\u001c\bK]8dKN\u001cX\r\u001a\u000b\u0003G\u0019DQAU2A\u0002\rBQ\u0001\u001b\u0001\u0005B%\fQcY;se\u0016tGoQ8n[&$X*\u001a;bI\u0006$\u0018\r\u0006\u0002.U\")!k\u001aa\u0001G!)A\u000e\u0001C![\u0006\u0019\u0012n\u001d)beRLG/[8o\u0007>l\u0007\u000f\\3uKR\u0011qI\u001c\u0005\u0006%.\u0004\ra\t")
public class SkewHandlingWithoutMapRangeValidator
extends AbstractPartitionCompletenessValidator {
    private final ConcurrentHashMap<Object, HashMap<Object, CommitMetadata>> totalSubPartitionsProcessed = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<Object, Object> partitionToSubPartitionCount = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<Object, CommitMetadata> currentCommitMetadataForReducer = JavaUtils.newConcurrentHashMap();

    private ConcurrentHashMap<Object, HashMap<Object, CommitMetadata>> totalSubPartitionsProcessed() {
        return this.totalSubPartitionsProcessed;
    }

    private ConcurrentHashMap<Object, Object> partitionToSubPartitionCount() {
        return this.partitionToSubPartitionCount;
    }

    private ConcurrentHashMap<Object, CommitMetadata> currentCommitMetadataForReducer() {
        return this.currentCommitMetadataForReducer;
    }

    @Override
    public Tuple2<Object, String> processSubPartition(int partitionId, int startMapIndex, int endMapIndex, CommitMetadata actualCommitMetadata, int expectedTotalMapperCount) {
        Preconditions.checkArgument(endMapIndex >= 0, "index of sub-partition %s must be greater than or equal to 0", endMapIndex);
        Preconditions.checkArgument(startMapIndex > endMapIndex, "startMapIndex %s must be greater than endMapIndex %s", startMapIndex, endMapIndex);
        ConcurrentHashMap<Object, HashMap<Object, CommitMetadata>> concurrentHashMap = this.totalSubPartitionsProcessed();
        synchronized (concurrentHashMap) {
            Object object;
            if (this.totalSubPartitionsProcessed().containsKey(BoxesRunTime.boxToInteger((int)partitionId))) {
                int currentSubPartitionCount = BoxesRunTime.unboxToInt((Object)this.partitionToSubPartitionCount().getOrDefault(BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)-1)));
                Preconditions.checkState(currentSubPartitionCount == startMapIndex, "total subpartition count mismatch for partitionId %s existing %s new %s", (Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)currentSubPartitionCount), (Object)BoxesRunTime.boxToInteger((int)startMapIndex));
                object = BoxedUnit.UNIT;
            } else {
                this.totalSubPartitionsProcessed().put(BoxesRunTime.boxToInteger((int)partitionId), new HashMap());
                object = this.partitionToSubPartitionCount().put(BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)startMapIndex));
            }
            HashMap<Object, CommitMetadata> subPartitionsProcessed = this.totalSubPartitionsProcessed().get(BoxesRunTime.boxToInteger((int)partitionId));
            if (subPartitionsProcessed.containsKey(BoxesRunTime.boxToInteger((int)endMapIndex))) {
                CommitMetadata existingCommitMetadata;
                CommitMetadata commitMetadata = existingCommitMetadata = subPartitionsProcessed.get(BoxesRunTime.boxToInteger((int)endMapIndex));
                CommitMetadata commitMetadata2 = actualCommitMetadata;
                if (!(commitMetadata != null ? !((Object)commitMetadata).equals(commitMetadata2) : commitMetadata2 != null)) {
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
                }
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mismatch in metadata for the same chunk range on retry: ", " existing: ", " new: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)endMapIndex), existingCommitMetadata, actualCommitMetadata})));
            }
            this.updateCommitMetadata(partitionId, actualCommitMetadata);
            subPartitionsProcessed.put(BoxesRunTime.boxToInteger((int)endMapIndex), actualCommitMetadata);
            int partitionProcessed = this.getTotalNumberOfSubPartitionsProcessed(partitionId);
            Preconditions.checkState(partitionProcessed <= startMapIndex, "Number of sub-partitions processed %s should less than total number of sub-partitions %s", partitionProcessed, startMapIndex);
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)"");
        }
    }

    private void updateCommitMetadata(int partitionId, CommitMetadata actualCommitMetadata) {
        CommitMetadata currentCommitMetadata = this.currentCommitMetadataForReducer().computeIfAbsent(BoxesRunTime.boxToInteger((int)partitionId), new Function<Object, CommitMetadata>(this){

            public CommitMetadata apply(int partitionId) {
                return new CommitMetadata();
            }
        });
        currentCommitMetadata.addCommitData(actualCommitMetadata);
    }

    private int getTotalNumberOfSubPartitionsProcessed(int partitionId) {
        return this.totalSubPartitionsProcessed().get(BoxesRunTime.boxToInteger((int)partitionId)).size();
    }

    @Override
    public CommitMetadata currentCommitMetadata(int partitionId) {
        return this.currentCommitMetadataForReducer().get(BoxesRunTime.boxToInteger((int)partitionId));
    }

    @Override
    public boolean isPartitionComplete(int partitionId) {
        return this.getTotalNumberOfSubPartitionsProcessed(partitionId) == BoxesRunTime.unboxToInt((Object)this.partitionToSubPartitionCount().get(BoxesRunTime.boxToInteger((int)partitionId)));
    }
}

