/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.ticker.impl;

import java.util.logging.Logger;
import net.openhft.ticker.ITicker;
import software.chronicle.enterprise.internals.impl.NativeAffinity;

public final class JNIClock
extends Enum<JNIClock>
implements ITicker {
    public static final /* enum */ JNIClock INSTANCE;
    public static final boolean LOADED;
    private static final Logger LOGGER;
    private static final int FACTOR_BITS = 17;
    private static final long START;
    private static long RDTSC_FACTOR;
    private static double RDTSC_MICRO_FACTOR;
    private static long CPU_FREQUENCY;
    private static final /* synthetic */ JNIClock[] $VALUES;

    public static JNIClock[] values() {
        return (JNIClock[])$VALUES.clone();
    }

    public static JNIClock valueOf(String name) {
        return Enum.valueOf(JNIClock.class, name);
    }

    static long tscToNano(long tsc) {
        return tsc * RDTSC_FACTOR >> 17;
    }

    private static void estimateFrequency(int factor) {
        long now;
        long start = System.nanoTime();
        while ((now = System.nanoTime()) == start) {
        }
        long end = start + (long)(factor * 1000000);
        long start0 = JNIClock.rdtsc0();
        while ((now = System.nanoTime()) < end) {
        }
        long end0 = JNIClock.rdtsc0();
        end = now;
        RDTSC_FACTOR = (end - start << 17) / (end0 - start0) - 1L;
        RDTSC_MICRO_FACTOR = 0.001 * (double)(end - start) / (double)(end0 - start0);
        CPU_FREQUENCY = (end0 - start0 + 1L) * 1000L / (end - start);
    }

    static native long rdtsc0();

    @Override
    public long nanoTime() {
        return JNIClock.tscToNano(JNIClock.rdtsc0() - START);
    }

    @Override
    public long ticks() {
        return JNIClock.rdtsc0();
    }

    @Override
    public long toNanos(long ticks) {
        return JNIClock.tscToNano(ticks);
    }

    @Override
    public double toMicros(double ticks) {
        return ticks * RDTSC_MICRO_FACTOR;
    }

    static {
        boolean loaded;
        long start;
        INSTANCE = new JNIClock();
        $VALUES = new JNIClock[]{INSTANCE};
        LOGGER = Logger.getLogger(JNIClock.class.getName());
        RDTSC_FACTOR = 131072L;
        RDTSC_MICRO_FACTOR = 0.001;
        CPU_FREQUENCY = 1000L;
        try {
            NativeAffinity.INSTANCE.getCpu();
            JNIClock.estimateFrequency(50);
            JNIClock.estimateFrequency(200);
            LOGGER.info("Estimated clock frequency was " + CPU_FREQUENCY + " MHz");
            start = JNIClock.rdtsc0();
            loaded = true;
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.fine("Unable to find libCEInternals in [" + System.getProperty("java.library.path") + "] " + ule);
            start = 0L;
            loaded = false;
        }
        LOADED = loaded;
        START = start;
    }
}

